<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiReportResponse StructType
 * @subpackage Structs
 */
class TipaltiReportResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The resultsFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resultsFile;
    /**
     * Constructor method for TipaltiReportResponse
     * @uses TipaltiReportResponse::setErrorCode()
     * @uses TipaltiReportResponse::setErrorMessage()
     * @uses TipaltiReportResponse::setResultsFile()
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $resultsFile
     */
    public function __construct($errorCode = null, $errorMessage = null, $resultsFile = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setResultsFile($resultsFile);
    }
    /**
     * Get errorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\TipaltiReportResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiReportResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get resultsFile value
     * @return string|null
     */
    public function getResultsFile()
    {
        return $this->resultsFile;
    }
    /**
     * Set resultsFile value
     * @param string $resultsFile
     * @return \StructType\TipaltiReportResponse
     */
    public function setResultsFile($resultsFile = null)
    {
        // validation for constraint: string
        if (!is_null($resultsFile) && !is_string($resultsFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultsFile, true), gettype($resultsFile)), __LINE__);
        }
        $this->resultsFile = $resultsFile;
        return $this;
    }
}
