<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiRelatedPurchaseOrder StructType
 * @subpackage Structs
 */
class TipaltiRelatedPurchaseOrder extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * The ItemNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemNumber;
    /**
     * The ExternalLineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalLineId;
    /**
     * The ItemExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemExternalId;
    /**
     * The PoLineGlAccountExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoLineGlAccountExternalId;
    /**
     * Constructor method for TipaltiRelatedPurchaseOrder
     * @uses TipaltiRelatedPurchaseOrder::setQuantity()
     * @uses TipaltiRelatedPurchaseOrder::setAmount()
     * @uses TipaltiRelatedPurchaseOrder::setPurchaseOrderNumber()
     * @uses TipaltiRelatedPurchaseOrder::setItemNumber()
     * @uses TipaltiRelatedPurchaseOrder::setExternalLineId()
     * @uses TipaltiRelatedPurchaseOrder::setItemExternalId()
     * @uses TipaltiRelatedPurchaseOrder::setPoLineGlAccountExternalId()
     * @param float $quantity
     * @param float $amount
     * @param string $purchaseOrderNumber
     * @param string $itemNumber
     * @param string $externalLineId
     * @param string $itemExternalId
     * @param string $poLineGlAccountExternalId
     */
    public function __construct($quantity = null, $amount = null, $purchaseOrderNumber = null, $itemNumber = null, $externalLineId = null, $itemExternalId = null, $poLineGlAccountExternalId = null)
    {
        $this
            ->setQuantity($quantity)
            ->setAmount($amount)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setItemNumber($itemNumber)
            ->setExternalLineId($externalLineId)
            ->setItemExternalId($itemExternalId)
            ->setPoLineGlAccountExternalId($poLineGlAccountExternalId);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param string $itemNumber
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemNumber) && !is_string($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get ExternalLineId value
     * @return string|null
     */
    public function getExternalLineId()
    {
        return $this->ExternalLineId;
    }
    /**
     * Set ExternalLineId value
     * @param string $externalLineId
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setExternalLineId($externalLineId = null)
    {
        // validation for constraint: string
        if (!is_null($externalLineId) && !is_string($externalLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalLineId, true), gettype($externalLineId)), __LINE__);
        }
        $this->ExternalLineId = $externalLineId;
        return $this;
    }
    /**
     * Get ItemExternalId value
     * @return string|null
     */
    public function getItemExternalId()
    {
        return $this->ItemExternalId;
    }
    /**
     * Set ItemExternalId value
     * @param string $itemExternalId
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setItemExternalId($itemExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($itemExternalId) && !is_string($itemExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemExternalId, true), gettype($itemExternalId)), __LINE__);
        }
        $this->ItemExternalId = $itemExternalId;
        return $this;
    }
    /**
     * Get PoLineGlAccountExternalId value
     * @return string|null
     */
    public function getPoLineGlAccountExternalId()
    {
        return $this->PoLineGlAccountExternalId;
    }
    /**
     * Set PoLineGlAccountExternalId value
     * @param string $poLineGlAccountExternalId
     * @return \StructType\TipaltiRelatedPurchaseOrder
     */
    public function setPoLineGlAccountExternalId($poLineGlAccountExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($poLineGlAccountExternalId) && !is_string($poLineGlAccountExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poLineGlAccountExternalId, true), gettype($poLineGlAccountExternalId)), __LINE__);
        }
        $this->PoLineGlAccountExternalId = $poLineGlAccountExternalId;
        return $this;
    }
}
