<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiProcessPaymentsSummary StructType
 * @subpackage Structs
 */
class TipaltiProcessPaymentsSummary extends AbstractStructBase
{
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $accountType;
    /**
     * The fundsRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $fundsRequired;
    /**
     * The outstandingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $outstandingAmount;
    /**
     * The accountCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountCurrency;
    /**
     * The tipaltiSummaryAmounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiSummaryAmounts
     */
    public $tipaltiSummaryAmounts;
    /**
     * Constructor method for TipaltiProcessPaymentsSummary
     * @uses TipaltiProcessPaymentsSummary::setAccountType()
     * @uses TipaltiProcessPaymentsSummary::setFundsRequired()
     * @uses TipaltiProcessPaymentsSummary::setOutstandingAmount()
     * @uses TipaltiProcessPaymentsSummary::setAccountCurrency()
     * @uses TipaltiProcessPaymentsSummary::setTipaltiSummaryAmounts()
     * @param int $accountType
     * @param float $fundsRequired
     * @param float $outstandingAmount
     * @param string $accountCurrency
     * @param \ArrayType\ArrayOfTipaltiSummaryAmounts $tipaltiSummaryAmounts
     */
    public function __construct($accountType = null, $fundsRequired = null, $outstandingAmount = null, $accountCurrency = null, \ArrayType\ArrayOfTipaltiSummaryAmounts $tipaltiSummaryAmounts = null)
    {
        $this
            ->setAccountType($accountType)
            ->setFundsRequired($fundsRequired)
            ->setOutstandingAmount($outstandingAmount)
            ->setAccountCurrency($accountCurrency)
            ->setTipaltiSummaryAmounts($tipaltiSummaryAmounts);
    }
    /**
     * Get accountType value
     * @return int
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @param int $accountType
     * @return \StructType\TipaltiProcessPaymentsSummary
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: int
        if (!is_null($accountType) && !(is_int($accountType) || ctype_digit($accountType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get fundsRequired value
     * @return float
     */
    public function getFundsRequired()
    {
        return $this->fundsRequired;
    }
    /**
     * Set fundsRequired value
     * @param float $fundsRequired
     * @return \StructType\TipaltiProcessPaymentsSummary
     */
    public function setFundsRequired($fundsRequired = null)
    {
        // validation for constraint: float
        if (!is_null($fundsRequired) && !(is_float($fundsRequired) || is_numeric($fundsRequired))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fundsRequired, true), gettype($fundsRequired)), __LINE__);
        }
        $this->fundsRequired = $fundsRequired;
        return $this;
    }
    /**
     * Get outstandingAmount value
     * @return float
     */
    public function getOutstandingAmount()
    {
        return $this->outstandingAmount;
    }
    /**
     * Set outstandingAmount value
     * @param float $outstandingAmount
     * @return \StructType\TipaltiProcessPaymentsSummary
     */
    public function setOutstandingAmount($outstandingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($outstandingAmount) && !(is_float($outstandingAmount) || is_numeric($outstandingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($outstandingAmount, true), gettype($outstandingAmount)), __LINE__);
        }
        $this->outstandingAmount = $outstandingAmount;
        return $this;
    }
    /**
     * Get accountCurrency value
     * @return string|null
     */
    public function getAccountCurrency()
    {
        return $this->accountCurrency;
    }
    /**
     * Set accountCurrency value
     * @param string $accountCurrency
     * @return \StructType\TipaltiProcessPaymentsSummary
     */
    public function setAccountCurrency($accountCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($accountCurrency) && !is_string($accountCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCurrency, true), gettype($accountCurrency)), __LINE__);
        }
        $this->accountCurrency = $accountCurrency;
        return $this;
    }
    /**
     * Get tipaltiSummaryAmounts value
     * @return \ArrayType\ArrayOfTipaltiSummaryAmounts|null
     */
    public function getTipaltiSummaryAmounts()
    {
        return $this->tipaltiSummaryAmounts;
    }
    /**
     * Set tipaltiSummaryAmounts value
     * @param \ArrayType\ArrayOfTipaltiSummaryAmounts $tipaltiSummaryAmounts
     * @return \StructType\TipaltiProcessPaymentsSummary
     */
    public function setTipaltiSummaryAmounts(\ArrayType\ArrayOfTipaltiSummaryAmounts $tipaltiSummaryAmounts = null)
    {
        $this->tipaltiSummaryAmounts = $tipaltiSummaryAmounts;
        return $this;
    }
}
