<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiProcessPaymentAsyncResult StructType
 * @subpackage Structs
 */
class TipaltiProcessPaymentAsyncResult extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $requestId;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for TipaltiProcessPaymentAsyncResult
     * @uses TipaltiProcessPaymentAsyncResult::setErrorCode()
     * @uses TipaltiProcessPaymentAsyncResult::setRequestId()
     * @uses TipaltiProcessPaymentAsyncResult::setErrorMessage()
     * @param string $errorCode
     * @param int $requestId
     * @param string $errorMessage
     */
    public function __construct($errorCode = null, $requestId = null, $errorMessage = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setRequestId($requestId)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiProcessPaymentAsyncResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get requestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\TipaltiProcessPaymentAsyncResult
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiProcessPaymentAsyncResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
}
