<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiPaymentTerm StructType
 * @subpackage Structs
 */
class TipaltiPaymentTerm extends AbstractStructBase
{
    /**
     * The Term
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Term;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for TipaltiPaymentTerm
     * @uses TipaltiPaymentTerm::setTerm()
     * @uses TipaltiPaymentTerm::setIsDefault()
     * @uses TipaltiPaymentTerm::setExternalId()
     * @uses TipaltiPaymentTerm::setName()
     * @param int $term
     * @param bool $isDefault
     * @param string $externalId
     * @param string $name
     */
    public function __construct($term = null, $isDefault = null, $externalId = null, $name = null)
    {
        $this
            ->setTerm($term)
            ->setIsDefault($isDefault)
            ->setExternalId($externalId)
            ->setName($name);
    }
    /**
     * Get Term value
     * @return int
     */
    public function getTerm()
    {
        return $this->Term;
    }
    /**
     * Set Term value
     * @param int $term
     * @return \StructType\TipaltiPaymentTerm
     */
    public function setTerm($term = null)
    {
        // validation for constraint: int
        if (!is_null($term) && !(is_int($term) || ctype_digit($term))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($term, true), gettype($term)), __LINE__);
        }
        $this->Term = $term;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\TipaltiPaymentTerm
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get ExternalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->ExternalId;
    }
    /**
     * Set ExternalId value
     * @param string $externalId
     * @return \StructType\TipaltiPaymentTerm
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->ExternalId = $externalId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TipaltiPaymentTerm
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
