<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiGetProviderAccountsResponse StructType
 * @subpackage Structs
 */
class TipaltiGetProviderAccountsResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The AccountsInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAccountInfo
     */
    public $AccountsInfo;
    /**
     * Constructor method for TipaltiGetProviderAccountsResponse
     * @uses TipaltiGetProviderAccountsResponse::setErrorCode()
     * @uses TipaltiGetProviderAccountsResponse::setErrorMessage()
     * @uses TipaltiGetProviderAccountsResponse::setAccountsInfo()
     * @param string $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfAccountInfo $accountsInfo
     */
    public function __construct($errorCode = null, $errorMessage = null, \ArrayType\ArrayOfAccountInfo $accountsInfo = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setAccountsInfo($accountsInfo);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiGetProviderAccountsResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiGetProviderAccountsResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get AccountsInfo value
     * @return \ArrayType\ArrayOfAccountInfo|null
     */
    public function getAccountsInfo()
    {
        return $this->AccountsInfo;
    }
    /**
     * Set AccountsInfo value
     * @param \ArrayType\ArrayOfAccountInfo $accountsInfo
     * @return \StructType\TipaltiGetProviderAccountsResponse
     */
    public function setAccountsInfo(\ArrayType\ArrayOfAccountInfo $accountsInfo = null)
    {
        $this->AccountsInfo = $accountsInfo;
        return $this;
    }
}
