<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiFee StructType
 * @subpackage Structs
 */
class TipaltiFee extends AbstractStructBase
{
    /**
     * The FeeCollectionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FeeCollectionDate;
    /**
     * The FeeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FeeAmount;
    /**
     * The TipaltiFeeReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipaltiFeeReference;
    /**
     * The FeeCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeCurrency;
    /**
     * The FeeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeDescription;
    /**
     * The PayerEntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntityName;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provider;
    /**
     * The AccountIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountIdentifier;
    /**
     * Constructor method for TipaltiFee
     * @uses TipaltiFee::setFeeCollectionDate()
     * @uses TipaltiFee::setFeeAmount()
     * @uses TipaltiFee::setTipaltiFeeReference()
     * @uses TipaltiFee::setFeeCurrency()
     * @uses TipaltiFee::setFeeDescription()
     * @uses TipaltiFee::setPayerEntityName()
     * @uses TipaltiFee::setProvider()
     * @uses TipaltiFee::setAccountIdentifier()
     * @param string $feeCollectionDate
     * @param float $feeAmount
     * @param string $tipaltiFeeReference
     * @param string $feeCurrency
     * @param string $feeDescription
     * @param string $payerEntityName
     * @param string $provider
     * @param string $accountIdentifier
     */
    public function __construct($feeCollectionDate = null, $feeAmount = null, $tipaltiFeeReference = null, $feeCurrency = null, $feeDescription = null, $payerEntityName = null, $provider = null, $accountIdentifier = null)
    {
        $this
            ->setFeeCollectionDate($feeCollectionDate)
            ->setFeeAmount($feeAmount)
            ->setTipaltiFeeReference($tipaltiFeeReference)
            ->setFeeCurrency($feeCurrency)
            ->setFeeDescription($feeDescription)
            ->setPayerEntityName($payerEntityName)
            ->setProvider($provider)
            ->setAccountIdentifier($accountIdentifier);
    }
    /**
     * Get FeeCollectionDate value
     * @return string
     */
    public function getFeeCollectionDate()
    {
        return $this->FeeCollectionDate;
    }
    /**
     * Set FeeCollectionDate value
     * @param string $feeCollectionDate
     * @return \StructType\TipaltiFee
     */
    public function setFeeCollectionDate($feeCollectionDate = null)
    {
        // validation for constraint: string
        if (!is_null($feeCollectionDate) && !is_string($feeCollectionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeCollectionDate, true), gettype($feeCollectionDate)), __LINE__);
        }
        $this->FeeCollectionDate = $feeCollectionDate;
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return float
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * Set FeeAmount value
     * @param float $feeAmount
     * @return \StructType\TipaltiFee
     */
    public function setFeeAmount($feeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($feeAmount) && !(is_float($feeAmount) || is_numeric($feeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($feeAmount, true), gettype($feeAmount)), __LINE__);
        }
        $this->FeeAmount = $feeAmount;
        return $this;
    }
    /**
     * Get TipaltiFeeReference value
     * @return string|null
     */
    public function getTipaltiFeeReference()
    {
        return $this->TipaltiFeeReference;
    }
    /**
     * Set TipaltiFeeReference value
     * @param string $tipaltiFeeReference
     * @return \StructType\TipaltiFee
     */
    public function setTipaltiFeeReference($tipaltiFeeReference = null)
    {
        // validation for constraint: string
        if (!is_null($tipaltiFeeReference) && !is_string($tipaltiFeeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipaltiFeeReference, true), gettype($tipaltiFeeReference)), __LINE__);
        }
        $this->TipaltiFeeReference = $tipaltiFeeReference;
        return $this;
    }
    /**
     * Get FeeCurrency value
     * @return string|null
     */
    public function getFeeCurrency()
    {
        return $this->FeeCurrency;
    }
    /**
     * Set FeeCurrency value
     * @param string $feeCurrency
     * @return \StructType\TipaltiFee
     */
    public function setFeeCurrency($feeCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($feeCurrency) && !is_string($feeCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeCurrency, true), gettype($feeCurrency)), __LINE__);
        }
        $this->FeeCurrency = $feeCurrency;
        return $this;
    }
    /**
     * Get FeeDescription value
     * @return string|null
     */
    public function getFeeDescription()
    {
        return $this->FeeDescription;
    }
    /**
     * Set FeeDescription value
     * @param string $feeDescription
     * @return \StructType\TipaltiFee
     */
    public function setFeeDescription($feeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($feeDescription) && !is_string($feeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeDescription, true), gettype($feeDescription)), __LINE__);
        }
        $this->FeeDescription = $feeDescription;
        return $this;
    }
    /**
     * Get PayerEntityName value
     * @return string|null
     */
    public function getPayerEntityName()
    {
        return $this->PayerEntityName;
    }
    /**
     * Set PayerEntityName value
     * @param string $payerEntityName
     * @return \StructType\TipaltiFee
     */
    public function setPayerEntityName($payerEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntityName) && !is_string($payerEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntityName, true), gettype($payerEntityName)), __LINE__);
        }
        $this->PayerEntityName = $payerEntityName;
        return $this;
    }
    /**
     * Get Provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param string $provider
     * @return \StructType\TipaltiFee
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get AccountIdentifier value
     * @return string|null
     */
    public function getAccountIdentifier()
    {
        return $this->AccountIdentifier;
    }
    /**
     * Set AccountIdentifier value
     * @param string $accountIdentifier
     * @return \StructType\TipaltiFee
     */
    public function setAccountIdentifier($accountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($accountIdentifier) && !is_string($accountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIdentifier, true), gettype($accountIdentifier)), __LINE__);
        }
        $this->AccountIdentifier = $accountIdentifier;
        return $this;
    }
}
