<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiExpandedProcessPaymentResponse StructType
 * @subpackage Structs
 */
class TipaltiExpandedProcessPaymentResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The linesResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExpandedLineResult
     */
    public $linesResults;
    /**
     * The summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiProcessPaymentsSummary
     */
    public $summary;
    /**
     * Constructor method for TipaltiExpandedProcessPaymentResponse
     * @uses TipaltiExpandedProcessPaymentResponse::setErrorCode()
     * @uses TipaltiExpandedProcessPaymentResponse::setErrorMessage()
     * @uses TipaltiExpandedProcessPaymentResponse::setLinesResults()
     * @uses TipaltiExpandedProcessPaymentResponse::setSummary()
     * @param int $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfExpandedLineResult $linesResults
     * @param \ArrayType\ArrayOfTipaltiProcessPaymentsSummary $summary
     */
    public function __construct($errorCode = null, $errorMessage = null, \ArrayType\ArrayOfExpandedLineResult $linesResults = null, \ArrayType\ArrayOfTipaltiProcessPaymentsSummary $summary = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setLinesResults($linesResults)
            ->setSummary($summary);
    }
    /**
     * Get errorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\TipaltiExpandedProcessPaymentResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiExpandedProcessPaymentResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get linesResults value
     * @return \ArrayType\ArrayOfExpandedLineResult|null
     */
    public function getLinesResults()
    {
        return $this->linesResults;
    }
    /**
     * Set linesResults value
     * @param \ArrayType\ArrayOfExpandedLineResult $linesResults
     * @return \StructType\TipaltiExpandedProcessPaymentResponse
     */
    public function setLinesResults(\ArrayType\ArrayOfExpandedLineResult $linesResults = null)
    {
        $this->linesResults = $linesResults;
        return $this;
    }
    /**
     * Get summary value
     * @return \ArrayType\ArrayOfTipaltiProcessPaymentsSummary|null
     */
    public function getSummary()
    {
        return $this->summary;
    }
    /**
     * Set summary value
     * @param \ArrayType\ArrayOfTipaltiProcessPaymentsSummary $summary
     * @return \StructType\TipaltiExpandedProcessPaymentResponse
     */
    public function setSummary(\ArrayType\ArrayOfTipaltiProcessPaymentsSummary $summary = null)
    {
        $this->summary = $summary;
        return $this;
    }
}
