<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiCustomFieldValue StructType
 * @subpackage Structs
 */
class TipaltiCustomFieldValue extends AbstractStructBase
{
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The CustomFieldName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomFieldName;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The PayerEntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntityName;
    /**
     * Constructor method for TipaltiCustomFieldValue
     * @uses TipaltiCustomFieldValue::setIsActive()
     * @uses TipaltiCustomFieldValue::setCustomFieldName()
     * @uses TipaltiCustomFieldValue::setCode()
     * @uses TipaltiCustomFieldValue::setValue()
     * @uses TipaltiCustomFieldValue::setPayerEntityName()
     * @param bool $isActive
     * @param string $customFieldName
     * @param string $code
     * @param string $value
     * @param string $payerEntityName
     */
    public function __construct($isActive = null, $customFieldName = null, $code = null, $value = null, $payerEntityName = null)
    {
        $this
            ->setIsActive($isActive)
            ->setCustomFieldName($customFieldName)
            ->setCode($code)
            ->setValue($value)
            ->setPayerEntityName($payerEntityName);
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\TipaltiCustomFieldValue
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get CustomFieldName value
     * @return string|null
     */
    public function getCustomFieldName()
    {
        return $this->CustomFieldName;
    }
    /**
     * Set CustomFieldName value
     * @param string $customFieldName
     * @return \StructType\TipaltiCustomFieldValue
     */
    public function setCustomFieldName($customFieldName = null)
    {
        // validation for constraint: string
        if (!is_null($customFieldName) && !is_string($customFieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customFieldName, true), gettype($customFieldName)), __LINE__);
        }
        $this->CustomFieldName = $customFieldName;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\TipaltiCustomFieldValue
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\TipaltiCustomFieldValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get PayerEntityName value
     * @return string|null
     */
    public function getPayerEntityName()
    {
        return $this->PayerEntityName;
    }
    /**
     * Set PayerEntityName value
     * @param string $payerEntityName
     * @return \StructType\TipaltiCustomFieldValue
     */
    public function setPayerEntityName($payerEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntityName) && !is_string($payerEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntityName, true), gettype($payerEntityName)), __LINE__);
        }
        $this->PayerEntityName = $payerEntityName;
        return $this;
    }
}
