<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiAccountInfo StructType
 * @subpackage Structs
 */
class TipaltiAccountInfo extends AbstractStructBase
{
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Provider;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The AccountIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountIdentifier;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for TipaltiAccountInfo
     * @uses TipaltiAccountInfo::setProvider()
     * @uses TipaltiAccountInfo::setBalance()
     * @uses TipaltiAccountInfo::setAccountIdentifier()
     * @uses TipaltiAccountInfo::setCurrency()
     * @param string $provider
     * @param float $balance
     * @param string $accountIdentifier
     * @param string $currency
     */
    public function __construct($provider = null, $balance = null, $accountIdentifier = null, $currency = null)
    {
        $this
            ->setProvider($provider)
            ->setBalance($balance)
            ->setAccountIdentifier($accountIdentifier)
            ->setCurrency($currency);
    }
    /**
     * Get Provider value
     * @return string
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @uses \EnumType\EPaymentProviderType::valueIsValid()
     * @uses \EnumType\EPaymentProviderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provider
     * @return \StructType\TipaltiAccountInfo
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EPaymentProviderType::valueIsValid($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EPaymentProviderType', is_array($provider) ? implode(', ', $provider) : var_export($provider, true), implode(', ', \EnumType\EPaymentProviderType::getValidValues())), __LINE__);
        }
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\TipaltiAccountInfo
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get AccountIdentifier value
     * @return string|null
     */
    public function getAccountIdentifier()
    {
        return $this->AccountIdentifier;
    }
    /**
     * Set AccountIdentifier value
     * @param string $accountIdentifier
     * @return \StructType\TipaltiAccountInfo
     */
    public function setAccountIdentifier($accountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($accountIdentifier) && !is_string($accountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIdentifier, true), gettype($accountIdentifier)), __LINE__);
        }
        $this->AccountIdentifier = $accountIdentifier;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TipaltiAccountInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
