<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedInvoice StructType
 * @subpackage Structs
 */
class RelatedInvoice extends AbstractStructBase
{
    /**
     * The AppliedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AppliedAmount;
    /**
     * The InvoiceRefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRefCode;
    /**
     * Constructor method for RelatedInvoice
     * @uses RelatedInvoice::setAppliedAmount()
     * @uses RelatedInvoice::setInvoiceRefCode()
     * @param float $appliedAmount
     * @param string $invoiceRefCode
     */
    public function __construct($appliedAmount = null, $invoiceRefCode = null)
    {
        $this
            ->setAppliedAmount($appliedAmount)
            ->setInvoiceRefCode($invoiceRefCode);
    }
    /**
     * Get AppliedAmount value
     * @return float
     */
    public function getAppliedAmount()
    {
        return $this->AppliedAmount;
    }
    /**
     * Set AppliedAmount value
     * @param float $appliedAmount
     * @return \StructType\RelatedInvoice
     */
    public function setAppliedAmount($appliedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($appliedAmount) && !(is_float($appliedAmount) || is_numeric($appliedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($appliedAmount, true), gettype($appliedAmount)), __LINE__);
        }
        $this->AppliedAmount = $appliedAmount;
        return $this;
    }
    /**
     * Get InvoiceRefCode value
     * @return string|null
     */
    public function getInvoiceRefCode()
    {
        return $this->InvoiceRefCode;
    }
    /**
     * Set InvoiceRefCode value
     * @param string $invoiceRefCode
     * @return \StructType\RelatedInvoice
     */
    public function setInvoiceRefCode($invoiceRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRefCode) && !is_string($invoiceRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRefCode, true), gettype($invoiceRefCode)), __LINE__);
        }
        $this->InvoiceRefCode = $invoiceRefCode;
        return $this;
    }
}
