<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessPayments StructType
 * @subpackage Structs
 */
class ProcessPayments extends AbstractStructBase
{
    /**
     * The timeStamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timeStamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The paymentGroupTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentGroupTitle;
    /**
     * The tipaltiPaymentsOrders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiPaymentOrderItem
     */
    public $tipaltiPaymentsOrders;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * Constructor method for ProcessPayments
     * @uses ProcessPayments::setTimeStamp()
     * @uses ProcessPayments::setPayerName()
     * @uses ProcessPayments::setPaymentGroupTitle()
     * @uses ProcessPayments::setTipaltiPaymentsOrders()
     * @uses ProcessPayments::setKey()
     * @param float $timeStamp
     * @param string $payerName
     * @param string $paymentGroupTitle
     * @param \ArrayType\ArrayOfTipaltiPaymentOrderItem $tipaltiPaymentsOrders
     * @param string $key
     */
    public function __construct($timeStamp = null, $payerName = null, $paymentGroupTitle = null, \ArrayType\ArrayOfTipaltiPaymentOrderItem $tipaltiPaymentsOrders = null, $key = null)
    {
        $this
            ->setTimeStamp($timeStamp)
            ->setPayerName($payerName)
            ->setPaymentGroupTitle($paymentGroupTitle)
            ->setTipaltiPaymentsOrders($tipaltiPaymentsOrders)
            ->setKey($key);
    }
    /**
     * Get timeStamp value
     * @return float
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param float $timeStamp
     * @return \StructType\ProcessPayments
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: float
        if (!is_null($timeStamp) && !(is_float($timeStamp) || is_numeric($timeStamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\ProcessPayments
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get paymentGroupTitle value
     * @return string|null
     */
    public function getPaymentGroupTitle()
    {
        return $this->paymentGroupTitle;
    }
    /**
     * Set paymentGroupTitle value
     * @param string $paymentGroupTitle
     * @return \StructType\ProcessPayments
     */
    public function setPaymentGroupTitle($paymentGroupTitle = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGroupTitle) && !is_string($paymentGroupTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentGroupTitle, true), gettype($paymentGroupTitle)), __LINE__);
        }
        $this->paymentGroupTitle = $paymentGroupTitle;
        return $this;
    }
    /**
     * Get tipaltiPaymentsOrders value
     * @return \ArrayType\ArrayOfTipaltiPaymentOrderItem|null
     */
    public function getTipaltiPaymentsOrders()
    {
        return $this->tipaltiPaymentsOrders;
    }
    /**
     * Set tipaltiPaymentsOrders value
     * @param \ArrayType\ArrayOfTipaltiPaymentOrderItem $tipaltiPaymentsOrders
     * @return \StructType\ProcessPayments
     */
    public function setTipaltiPaymentsOrders(\ArrayType\ArrayOfTipaltiPaymentOrderItem $tipaltiPaymentsOrders = null)
    {
        $this->tipaltiPaymentsOrders = $tipaltiPaymentsOrders;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\ProcessPayments
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
