<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLine StructType
 * @subpackage Structs
 */
class InvoiceLine extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LineType;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxAmount;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxRate;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Total;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The InvoiceInternalNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalNotes;
    /**
     * The EWalletMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EWalletMessage;
    /**
     * The BankingMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankingMessage;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $CustomFields;
    /**
     * The GLAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TipaltiGLAccount
     */
    public $GLAccount;
    /**
     * The LineExternalMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineExternalMetadata;
    /**
     * The BillLineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillLineID;
    /**
     * The TaxCodeExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCodeExternalId;
    /**
     * The RelatedPurchaseOrders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiRelatedPurchaseOrder
     */
    public $RelatedPurchaseOrders;
    /**
     * Constructor method for InvoiceLine
     * @uses InvoiceLine::setAmount()
     * @uses InvoiceLine::setLineType()
     * @uses InvoiceLine::setQuantity()
     * @uses InvoiceLine::setTaxAmount()
     * @uses InvoiceLine::setTaxRate()
     * @uses InvoiceLine::setTotal()
     * @uses InvoiceLine::setCurrency()
     * @uses InvoiceLine::setDescription()
     * @uses InvoiceLine::setInvoiceInternalNotes()
     * @uses InvoiceLine::setEWalletMessage()
     * @uses InvoiceLine::setBankingMessage()
     * @uses InvoiceLine::setCustomFields()
     * @uses InvoiceLine::setGLAccount()
     * @uses InvoiceLine::setLineExternalMetadata()
     * @uses InvoiceLine::setBillLineID()
     * @uses InvoiceLine::setTaxCodeExternalId()
     * @uses InvoiceLine::setRelatedPurchaseOrders()
     * @param float $amount
     * @param string $lineType
     * @param float $quantity
     * @param float $taxAmount
     * @param float $taxRate
     * @param float $total
     * @param string $currency
     * @param string $description
     * @param string $invoiceInternalNotes
     * @param string $eWalletMessage
     * @param string $bankingMessage
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @param \StructType\TipaltiGLAccount $gLAccount
     * @param string $lineExternalMetadata
     * @param string $billLineID
     * @param string $taxCodeExternalId
     * @param \ArrayType\ArrayOfTipaltiRelatedPurchaseOrder $relatedPurchaseOrders
     */
    public function __construct($amount = null, $lineType = null, $quantity = null, $taxAmount = null, $taxRate = null, $total = null, $currency = null, $description = null, $invoiceInternalNotes = null, $eWalletMessage = null, $bankingMessage = null, \ArrayType\ArrayOfKeyValuePair $customFields = null, \StructType\TipaltiGLAccount $gLAccount = null, $lineExternalMetadata = null, $billLineID = null, $taxCodeExternalId = null, \ArrayType\ArrayOfTipaltiRelatedPurchaseOrder $relatedPurchaseOrders = null)
    {
        $this
            ->setAmount($amount)
            ->setLineType($lineType)
            ->setQuantity($quantity)
            ->setTaxAmount($taxAmount)
            ->setTaxRate($taxRate)
            ->setTotal($total)
            ->setCurrency($currency)
            ->setDescription($description)
            ->setInvoiceInternalNotes($invoiceInternalNotes)
            ->setEWalletMessage($eWalletMessage)
            ->setBankingMessage($bankingMessage)
            ->setCustomFields($customFields)
            ->setGLAccount($gLAccount)
            ->setLineExternalMetadata($lineExternalMetadata)
            ->setBillLineID($billLineID)
            ->setTaxCodeExternalId($taxCodeExternalId)
            ->setRelatedPurchaseOrders($relatedPurchaseOrders);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\InvoiceLine
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get LineType value
     * @return string
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @uses \EnumType\EInvoiceLineType::valueIsValid()
     * @uses \EnumType\EInvoiceLineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineType
     * @return \StructType\InvoiceLine
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EInvoiceLineType::valueIsValid($lineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EInvoiceLineType', is_array($lineType) ? implode(', ', $lineType) : var_export($lineType, true), implode(', ', \EnumType\EInvoiceLineType::getValidValues())), __LINE__);
        }
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\InvoiceLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\InvoiceLine
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \StructType\InvoiceLine
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get Total value
     * @return float
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \StructType\InvoiceLine
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\InvoiceLine
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\InvoiceLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get InvoiceInternalNotes value
     * @return string|null
     */
    public function getInvoiceInternalNotes()
    {
        return $this->InvoiceInternalNotes;
    }
    /**
     * Set InvoiceInternalNotes value
     * @param string $invoiceInternalNotes
     * @return \StructType\InvoiceLine
     */
    public function setInvoiceInternalNotes($invoiceInternalNotes = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalNotes) && !is_string($invoiceInternalNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalNotes, true), gettype($invoiceInternalNotes)), __LINE__);
        }
        $this->InvoiceInternalNotes = $invoiceInternalNotes;
        return $this;
    }
    /**
     * Get EWalletMessage value
     * @return string|null
     */
    public function getEWalletMessage()
    {
        return $this->EWalletMessage;
    }
    /**
     * Set EWalletMessage value
     * @param string $eWalletMessage
     * @return \StructType\InvoiceLine
     */
    public function setEWalletMessage($eWalletMessage = null)
    {
        // validation for constraint: string
        if (!is_null($eWalletMessage) && !is_string($eWalletMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eWalletMessage, true), gettype($eWalletMessage)), __LINE__);
        }
        $this->EWalletMessage = $eWalletMessage;
        return $this;
    }
    /**
     * Get BankingMessage value
     * @return string|null
     */
    public function getBankingMessage()
    {
        return $this->BankingMessage;
    }
    /**
     * Set BankingMessage value
     * @param string $bankingMessage
     * @return \StructType\InvoiceLine
     */
    public function setBankingMessage($bankingMessage = null)
    {
        // validation for constraint: string
        if (!is_null($bankingMessage) && !is_string($bankingMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankingMessage, true), gettype($bankingMessage)), __LINE__);
        }
        $this->BankingMessage = $bankingMessage;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @return \StructType\InvoiceLine
     */
    public function setCustomFields(\ArrayType\ArrayOfKeyValuePair $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get GLAccount value
     * @return \StructType\TipaltiGLAccount|null
     */
    public function getGLAccount()
    {
        return $this->GLAccount;
    }
    /**
     * Set GLAccount value
     * @param \StructType\TipaltiGLAccount $gLAccount
     * @return \StructType\InvoiceLine
     */
    public function setGLAccount(\StructType\TipaltiGLAccount $gLAccount = null)
    {
        $this->GLAccount = $gLAccount;
        return $this;
    }
    /**
     * Get LineExternalMetadata value
     * @return string|null
     */
    public function getLineExternalMetadata()
    {
        return $this->LineExternalMetadata;
    }
    /**
     * Set LineExternalMetadata value
     * @param string $lineExternalMetadata
     * @return \StructType\InvoiceLine
     */
    public function setLineExternalMetadata($lineExternalMetadata = null)
    {
        // validation for constraint: string
        if (!is_null($lineExternalMetadata) && !is_string($lineExternalMetadata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineExternalMetadata, true), gettype($lineExternalMetadata)), __LINE__);
        }
        $this->LineExternalMetadata = $lineExternalMetadata;
        return $this;
    }
    /**
     * Get BillLineID value
     * @return string|null
     */
    public function getBillLineID()
    {
        return $this->BillLineID;
    }
    /**
     * Set BillLineID value
     * @param string $billLineID
     * @return \StructType\InvoiceLine
     */
    public function setBillLineID($billLineID = null)
    {
        // validation for constraint: string
        if (!is_null($billLineID) && !is_string($billLineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billLineID, true), gettype($billLineID)), __LINE__);
        }
        $this->BillLineID = $billLineID;
        return $this;
    }
    /**
     * Get TaxCodeExternalId value
     * @return string|null
     */
    public function getTaxCodeExternalId()
    {
        return $this->TaxCodeExternalId;
    }
    /**
     * Set TaxCodeExternalId value
     * @param string $taxCodeExternalId
     * @return \StructType\InvoiceLine
     */
    public function setTaxCodeExternalId($taxCodeExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($taxCodeExternalId) && !is_string($taxCodeExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCodeExternalId, true), gettype($taxCodeExternalId)), __LINE__);
        }
        $this->TaxCodeExternalId = $taxCodeExternalId;
        return $this;
    }
    /**
     * Get RelatedPurchaseOrders value
     * @return \ArrayType\ArrayOfTipaltiRelatedPurchaseOrder|null
     */
    public function getRelatedPurchaseOrders()
    {
        return $this->RelatedPurchaseOrders;
    }
    /**
     * Set RelatedPurchaseOrders value
     * @param \ArrayType\ArrayOfTipaltiRelatedPurchaseOrder $relatedPurchaseOrders
     * @return \StructType\InvoiceLine
     */
    public function setRelatedPurchaseOrders(\ArrayType\ArrayOfTipaltiRelatedPurchaseOrder $relatedPurchaseOrders = null)
    {
        $this->RelatedPurchaseOrders = $relatedPurchaseOrders;
        return $this;
    }
}
