<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsReceivedNotificationLine StructType
 * @subpackage Structs
 */
class GoodsReceivedNotificationLine extends AbstractStructBase
{
    /**
     * The QuantityShipped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QuantityShipped;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemUnits;
    /**
     * The LineNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineNotes;
    /**
     * The PoLineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoLineId;
    /**
     * Constructor method for GoodsReceivedNotificationLine
     * @uses GoodsReceivedNotificationLine::setQuantityShipped()
     * @uses GoodsReceivedNotificationLine::setInvoiceNumber()
     * @uses GoodsReceivedNotificationLine::setItemCode()
     * @uses GoodsReceivedNotificationLine::setItemDescription()
     * @uses GoodsReceivedNotificationLine::setItemUnits()
     * @uses GoodsReceivedNotificationLine::setLineNotes()
     * @uses GoodsReceivedNotificationLine::setPoLineId()
     * @param float $quantityShipped
     * @param string $invoiceNumber
     * @param string $itemCode
     * @param string $itemDescription
     * @param string $itemUnits
     * @param string $lineNotes
     * @param string $poLineId
     */
    public function __construct($quantityShipped = null, $invoiceNumber = null, $itemCode = null, $itemDescription = null, $itemUnits = null, $lineNotes = null, $poLineId = null)
    {
        $this
            ->setQuantityShipped($quantityShipped)
            ->setInvoiceNumber($invoiceNumber)
            ->setItemCode($itemCode)
            ->setItemDescription($itemDescription)
            ->setItemUnits($itemUnits)
            ->setLineNotes($lineNotes)
            ->setPoLineId($poLineId);
    }
    /**
     * Get QuantityShipped value
     * @return float
     */
    public function getQuantityShipped()
    {
        return $this->QuantityShipped;
    }
    /**
     * Set QuantityShipped value
     * @param float $quantityShipped
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setQuantityShipped($quantityShipped = null)
    {
        // validation for constraint: float
        if (!is_null($quantityShipped) && !(is_float($quantityShipped) || is_numeric($quantityShipped))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityShipped, true), gettype($quantityShipped)), __LINE__);
        }
        $this->QuantityShipped = $quantityShipped;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get ItemUnits value
     * @return string|null
     */
    public function getItemUnits()
    {
        return $this->ItemUnits;
    }
    /**
     * Set ItemUnits value
     * @param string $itemUnits
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setItemUnits($itemUnits = null)
    {
        // validation for constraint: string
        if (!is_null($itemUnits) && !is_string($itemUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemUnits, true), gettype($itemUnits)), __LINE__);
        }
        $this->ItemUnits = $itemUnits;
        return $this;
    }
    /**
     * Get LineNotes value
     * @return string|null
     */
    public function getLineNotes()
    {
        return $this->LineNotes;
    }
    /**
     * Set LineNotes value
     * @param string $lineNotes
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setLineNotes($lineNotes = null)
    {
        // validation for constraint: string
        if (!is_null($lineNotes) && !is_string($lineNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineNotes, true), gettype($lineNotes)), __LINE__);
        }
        $this->LineNotes = $lineNotes;
        return $this;
    }
    /**
     * Get PoLineId value
     * @return string|null
     */
    public function getPoLineId()
    {
        return $this->PoLineId;
    }
    /**
     * Set PoLineId value
     * @param string $poLineId
     * @return \StructType\GoodsReceivedNotificationLine
     */
    public function setPoLineId($poLineId = null)
    {
        // validation for constraint: string
        if (!is_null($poLineId) && !is_string($poLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poLineId, true), gettype($poLineId)), __LINE__);
        }
        $this->PoLineId = $poLineId;
        return $this;
    }
}
