<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPayerFees StructType
 * @subpackage Structs
 */
class GetPayerFees extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The beginDateTimeStamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $beginDateTimeStamp;
    /**
     * The endDateTimeStamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $endDateTimeStamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * Constructor method for GetPayerFees
     * @uses GetPayerFees::setTimestamp()
     * @uses GetPayerFees::setBeginDateTimeStamp()
     * @uses GetPayerFees::setEndDateTimeStamp()
     * @uses GetPayerFees::setPayerName()
     * @uses GetPayerFees::setKey()
     * @param float $timestamp
     * @param float $beginDateTimeStamp
     * @param float $endDateTimeStamp
     * @param string $payerName
     * @param string $key
     */
    public function __construct($timestamp = null, $beginDateTimeStamp = null, $endDateTimeStamp = null, $payerName = null, $key = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setBeginDateTimeStamp($beginDateTimeStamp)
            ->setEndDateTimeStamp($endDateTimeStamp)
            ->setPayerName($payerName)
            ->setKey($key);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\GetPayerFees
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get beginDateTimeStamp value
     * @return float
     */
    public function getBeginDateTimeStamp()
    {
        return $this->beginDateTimeStamp;
    }
    /**
     * Set beginDateTimeStamp value
     * @param float $beginDateTimeStamp
     * @return \StructType\GetPayerFees
     */
    public function setBeginDateTimeStamp($beginDateTimeStamp = null)
    {
        // validation for constraint: float
        if (!is_null($beginDateTimeStamp) && !(is_float($beginDateTimeStamp) || is_numeric($beginDateTimeStamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beginDateTimeStamp, true), gettype($beginDateTimeStamp)), __LINE__);
        }
        $this->beginDateTimeStamp = $beginDateTimeStamp;
        return $this;
    }
    /**
     * Get endDateTimeStamp value
     * @return float
     */
    public function getEndDateTimeStamp()
    {
        return $this->endDateTimeStamp;
    }
    /**
     * Set endDateTimeStamp value
     * @param float $endDateTimeStamp
     * @return \StructType\GetPayerFees
     */
    public function setEndDateTimeStamp($endDateTimeStamp = null)
    {
        // validation for constraint: float
        if (!is_null($endDateTimeStamp) && !(is_float($endDateTimeStamp) || is_numeric($endDateTimeStamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($endDateTimeStamp, true), gettype($endDateTimeStamp)), __LINE__);
        }
        $this->endDateTimeStamp = $endDateTimeStamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\GetPayerFees
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetPayerFees
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
