<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPayeeInvoicesListDetails StructType
 * @subpackage Structs
 */
class GetPayeeInvoicesListDetails extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The invoicesRefCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $invoicesRefCodes;
    /**
     * Constructor method for GetPayeeInvoicesListDetails
     * @uses GetPayeeInvoicesListDetails::setTimestamp()
     * @uses GetPayeeInvoicesListDetails::setPayerName()
     * @uses GetPayeeInvoicesListDetails::setKey()
     * @uses GetPayeeInvoicesListDetails::setInvoicesRefCodes()
     * @param float $timestamp
     * @param string $payerName
     * @param string $key
     * @param \ArrayType\ArrayOfString $invoicesRefCodes
     */
    public function __construct($timestamp = null, $payerName = null, $key = null, \ArrayType\ArrayOfString $invoicesRefCodes = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setInvoicesRefCodes($invoicesRefCodes);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\GetPayeeInvoicesListDetails
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\GetPayeeInvoicesListDetails
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetPayeeInvoicesListDetails
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get invoicesRefCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getInvoicesRefCodes()
    {
        return $this->invoicesRefCodes;
    }
    /**
     * Set invoicesRefCodes value
     * @param \ArrayType\ArrayOfString $invoicesRefCodes
     * @return \StructType\GetPayeeInvoicesListDetails
     */
    public function setInvoicesRefCodes(\ArrayType\ArrayOfString $invoicesRefCodes = null)
    {
        $this->invoicesRefCodes = $invoicesRefCodes;
        return $this;
    }
}
