<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentOrdersReport StructType
 * @subpackage Structs
 */
class CreatePaymentOrdersReport extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endTime;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * Constructor method for CreatePaymentOrdersReport
     * @uses CreatePaymentOrdersReport::setTimestamp()
     * @uses CreatePaymentOrdersReport::setStartTime()
     * @uses CreatePaymentOrdersReport::setEndTime()
     * @uses CreatePaymentOrdersReport::setPayerName()
     * @uses CreatePaymentOrdersReport::setKey()
     * @param float $timestamp
     * @param string $startTime
     * @param string $endTime
     * @param string $payerName
     * @param string $key
     */
    public function __construct($timestamp = null, $startTime = null, $endTime = null, $payerName = null, $key = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setPayerName($payerName)
            ->setKey($key);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\CreatePaymentOrdersReport
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get startTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @param string $startTime
     * @return \StructType\CreatePaymentOrdersReport
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \StructType\CreatePaymentOrdersReport
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\CreatePaymentOrdersReport
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\CreatePaymentOrdersReport
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
