<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrUpdateTaxCodes StructType
 * @subpackage Structs
 */
class CreateOrUpdateTaxCodes extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The taxCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiTaxCode
     */
    public $taxCodes;
    /**
     * Constructor method for CreateOrUpdateTaxCodes
     * @uses CreateOrUpdateTaxCodes::setTimestamp()
     * @uses CreateOrUpdateTaxCodes::setPayerName()
     * @uses CreateOrUpdateTaxCodes::setKey()
     * @uses CreateOrUpdateTaxCodes::setTaxCodes()
     * @param float $timestamp
     * @param string $payerName
     * @param string $key
     * @param \ArrayType\ArrayOfTipaltiTaxCode $taxCodes
     */
    public function __construct($timestamp = null, $payerName = null, $key = null, \ArrayType\ArrayOfTipaltiTaxCode $taxCodes = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setTaxCodes($taxCodes);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\CreateOrUpdateTaxCodes
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\CreateOrUpdateTaxCodes
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\CreateOrUpdateTaxCodes
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get taxCodes value
     * @return \ArrayType\ArrayOfTipaltiTaxCode|null
     */
    public function getTaxCodes()
    {
        return $this->taxCodes;
    }
    /**
     * Set taxCodes value
     * @param \ArrayType\ArrayOfTipaltiTaxCode $taxCodes
     * @return \StructType\CreateOrUpdateTaxCodes
     */
    public function setTaxCodes(\ArrayType\ArrayOfTipaltiTaxCode $taxCodes = null)
    {
        $this->taxCodes = $taxCodes;
        return $this;
    }
}
