<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrUpdatePaymentTermsResult StructType
 * @subpackage Structs
 */
class CreateOrUpdatePaymentTermsResult extends TipaltiResponse
{
    /**
     * The CreatedCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedCount;
    /**
     * The UpdatedCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UpdatedCount;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiPaymentTerm
     */
    public $PaymentTerms;
    /**
     * Constructor method for CreateOrUpdatePaymentTermsResult
     * @uses CreateOrUpdatePaymentTermsResult::setCreatedCount()
     * @uses CreateOrUpdatePaymentTermsResult::setUpdatedCount()
     * @uses CreateOrUpdatePaymentTermsResult::setPaymentTerms()
     * @param int $createdCount
     * @param int $updatedCount
     * @param \ArrayType\ArrayOfTipaltiPaymentTerm $paymentTerms
     */
    public function __construct($createdCount = null, $updatedCount = null, \ArrayType\ArrayOfTipaltiPaymentTerm $paymentTerms = null)
    {
        $this
            ->setCreatedCount($createdCount)
            ->setUpdatedCount($updatedCount)
            ->setPaymentTerms($paymentTerms);
    }
    /**
     * Get CreatedCount value
     * @return int
     */
    public function getCreatedCount()
    {
        return $this->CreatedCount;
    }
    /**
     * Set CreatedCount value
     * @param int $createdCount
     * @return \StructType\CreateOrUpdatePaymentTermsResult
     */
    public function setCreatedCount($createdCount = null)
    {
        // validation for constraint: int
        if (!is_null($createdCount) && !(is_int($createdCount) || ctype_digit($createdCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createdCount, true), gettype($createdCount)), __LINE__);
        }
        $this->CreatedCount = $createdCount;
        return $this;
    }
    /**
     * Get UpdatedCount value
     * @return int
     */
    public function getUpdatedCount()
    {
        return $this->UpdatedCount;
    }
    /**
     * Set UpdatedCount value
     * @param int $updatedCount
     * @return \StructType\CreateOrUpdatePaymentTermsResult
     */
    public function setUpdatedCount($updatedCount = null)
    {
        // validation for constraint: int
        if (!is_null($updatedCount) && !(is_int($updatedCount) || ctype_digit($updatedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updatedCount, true), gettype($updatedCount)), __LINE__);
        }
        $this->UpdatedCount = $updatedCount;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \ArrayType\ArrayOfTipaltiPaymentTerm|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param \ArrayType\ArrayOfTipaltiPaymentTerm $paymentTerms
     * @return \StructType\CreateOrUpdatePaymentTermsResult
     */
    public function setPaymentTerms(\ArrayType\ArrayOfTipaltiPaymentTerm $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
}
