<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyVendorCredit StructType
 * @subpackage Structs
 */
class ApplyVendorCredit extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The vendorCreditRefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorCreditRefCode;
    /**
     * The relatedInvoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRelatedInvoice
     */
    public $relatedInvoices;
    /**
     * Constructor method for ApplyVendorCredit
     * @uses ApplyVendorCredit::setTimestamp()
     * @uses ApplyVendorCredit::setPayerName()
     * @uses ApplyVendorCredit::setKey()
     * @uses ApplyVendorCredit::setVendorCreditRefCode()
     * @uses ApplyVendorCredit::setRelatedInvoices()
     * @param float $timestamp
     * @param string $payerName
     * @param string $key
     * @param string $vendorCreditRefCode
     * @param \ArrayType\ArrayOfRelatedInvoice $relatedInvoices
     */
    public function __construct($timestamp = null, $payerName = null, $key = null, $vendorCreditRefCode = null, \ArrayType\ArrayOfRelatedInvoice $relatedInvoices = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setVendorCreditRefCode($vendorCreditRefCode)
            ->setRelatedInvoices($relatedInvoices);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\ApplyVendorCredit
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\ApplyVendorCredit
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\ApplyVendorCredit
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get vendorCreditRefCode value
     * @return string|null
     */
    public function getVendorCreditRefCode()
    {
        return $this->vendorCreditRefCode;
    }
    /**
     * Set vendorCreditRefCode value
     * @param string $vendorCreditRefCode
     * @return \StructType\ApplyVendorCredit
     */
    public function setVendorCreditRefCode($vendorCreditRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCreditRefCode) && !is_string($vendorCreditRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCreditRefCode, true), gettype($vendorCreditRefCode)), __LINE__);
        }
        $this->vendorCreditRefCode = $vendorCreditRefCode;
        return $this;
    }
    /**
     * Get relatedInvoices value
     * @return \ArrayType\ArrayOfRelatedInvoice|null
     */
    public function getRelatedInvoices()
    {
        return $this->relatedInvoices;
    }
    /**
     * Set relatedInvoices value
     * @param \ArrayType\ArrayOfRelatedInvoice $relatedInvoices
     * @return \StructType\ApplyVendorCredit
     */
    public function setRelatedInvoices(\ArrayType\ArrayOfRelatedInvoice $relatedInvoices = null)
    {
        $this->relatedInvoices = $relatedInvoices;
        return $this;
    }
}
