<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Log ServiceType
 * @subpackage Services
 */
class Log extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LogIntegrationError
     * Meta information extracted from the WSDL
     * - documentation: Log integration errors from Tipalti/Apps (NetSuite/QuickBooks/etc...) Integrations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LogIntegrationError $parameters
     * @return \StructType\LogIntegrationErrorResponse|bool
     */
    public function LogIntegrationError(\StructType\LogIntegrationError $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LogIntegrationError($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LogIntegrationErrorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
