<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apply ServiceType
 * @subpackage Services
 */
class Apply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ApplyVendorCredit
     * Meta information extracted from the WSDL
     * - documentation: Applies vendor credit for related bills
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplyVendorCredit $parameters
     * @return \StructType\ApplyVendorCreditResponse|bool
     */
    public function ApplyVendorCredit(\StructType\ApplyVendorCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ApplyVendorCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ApplyVendorCreditResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
