<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CustomFieldType EnumType
 * @subpackage Enumerations
 */
class CustomFieldType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'FreeText'
     * @return string 'FreeText'
     */
    const VALUE_FREE_TEXT = 'FreeText';
    /**
     * Constant for value 'UniqueText'
     * @return string 'UniqueText'
     */
    const VALUE_UNIQUE_TEXT = 'UniqueText';
    /**
     * Constant for value 'MultipleValues'
     * @return string 'MultipleValues'
     */
    const VALUE_MULTIPLE_VALUES = 'MultipleValues';
    /**
     * Constant for value 'ListOfValues'
     * @return string 'ListOfValues'
     */
    const VALUE_LIST_OF_VALUES = 'ListOfValues';
    /**
     * Return allowed values
     * @uses self::VALUE_FREE_TEXT
     * @uses self::VALUE_UNIQUE_TEXT
     * @uses self::VALUE_MULTIPLE_VALUES
     * @uses self::VALUE_LIST_OF_VALUES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FREE_TEXT,
            self::VALUE_UNIQUE_TEXT,
            self::VALUE_MULTIPLE_VALUES,
            self::VALUE_LIST_OF_VALUES,
        );
    }
}
