<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTipaltiAccountInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfTipaltiAccountInfo extends AbstractStructArrayBase
{
    /**
     * The TipaltiAccountInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipaltiAccountInfo[]
     */
    public $TipaltiAccountInfo;
    /**
     * Constructor method for ArrayOfTipaltiAccountInfo
     * @uses ArrayOfTipaltiAccountInfo::setTipaltiAccountInfo()
     * @param \StructType\TipaltiAccountInfo[] $tipaltiAccountInfo
     */
    public function __construct(array $tipaltiAccountInfo = array())
    {
        $this
            ->setTipaltiAccountInfo($tipaltiAccountInfo);
    }
    /**
     * Get TipaltiAccountInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipaltiAccountInfo[]|null
     */
    public function getTipaltiAccountInfo()
    {
        return isset($this->TipaltiAccountInfo) ? $this->TipaltiAccountInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTipaltiAccountInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTipaltiAccountInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTipaltiAccountInfoForArrayConstraintsFromSetTipaltiAccountInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTipaltiAccountInfoTipaltiAccountInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTipaltiAccountInfoTipaltiAccountInfoItem instanceof \StructType\TipaltiAccountInfo) {
                $invalidValues[] = is_object($arrayOfTipaltiAccountInfoTipaltiAccountInfoItem) ? get_class($arrayOfTipaltiAccountInfoTipaltiAccountInfoItem) : sprintf('%s(%s)', gettype($arrayOfTipaltiAccountInfoTipaltiAccountInfoItem), var_export($arrayOfTipaltiAccountInfoTipaltiAccountInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TipaltiAccountInfo property can only contain items of type \StructType\TipaltiAccountInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TipaltiAccountInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TipaltiAccountInfo[] $tipaltiAccountInfo
     * @return \ArrayType\ArrayOfTipaltiAccountInfo
     */
    public function setTipaltiAccountInfo(array $tipaltiAccountInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($tipaltiAccountInfoArrayErrorMessage = self::validateTipaltiAccountInfoForArrayConstraintsFromSetTipaltiAccountInfo($tipaltiAccountInfo))) {
            throw new \InvalidArgumentException($tipaltiAccountInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($tipaltiAccountInfo) || (is_array($tipaltiAccountInfo) && empty($tipaltiAccountInfo))) {
            unset($this->TipaltiAccountInfo);
        } else {
            $this->TipaltiAccountInfo = $tipaltiAccountInfo;
        }
        return $this;
    }
    /**
     * Add item to TipaltiAccountInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TipaltiAccountInfo $item
     * @return \ArrayType\ArrayOfTipaltiAccountInfo
     */
    public function addToTipaltiAccountInfo(\StructType\TipaltiAccountInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipaltiAccountInfo) {
            throw new \InvalidArgumentException(sprintf('The TipaltiAccountInfo property can only contain items of type \StructType\TipaltiAccountInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TipaltiAccountInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TipaltiAccountInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TipaltiAccountInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TipaltiAccountInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TipaltiAccountInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TipaltiAccountInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TipaltiAccountInfo
     */
    public function getAttributeName()
    {
        return 'TipaltiAccountInfo';
    }
}
