<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKeyValuePair ArrayType
 * @subpackage Arrays
 */
class ArrayOfKeyValuePair extends AbstractStructArrayBase
{
    /**
     * The KeyValuePair
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KeyValuePair[]
     */
    public $KeyValuePair;
    /**
     * Constructor method for ArrayOfKeyValuePair
     * @uses ArrayOfKeyValuePair::setKeyValuePair()
     * @param \StructType\KeyValuePair[] $keyValuePair
     */
    public function __construct(array $keyValuePair = array())
    {
        $this
            ->setKeyValuePair($keyValuePair);
    }
    /**
     * Get KeyValuePair value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KeyValuePair[]|null
     */
    public function getKeyValuePair()
    {
        return isset($this->KeyValuePair) ? $this->KeyValuePair : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKeyValuePair method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyValuePair method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyValuePairForArrayConstraintsFromSetKeyValuePair(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfKeyValuePairKeyValuePairItem) {
            // validation for constraint: itemType
            if (!$arrayOfKeyValuePairKeyValuePairItem instanceof \StructType\KeyValuePair) {
                $invalidValues[] = is_object($arrayOfKeyValuePairKeyValuePairItem) ? get_class($arrayOfKeyValuePairKeyValuePairItem) : sprintf('%s(%s)', gettype($arrayOfKeyValuePairKeyValuePairItem), var_export($arrayOfKeyValuePairKeyValuePairItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeyValuePair property can only contain items of type \StructType\KeyValuePair, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeyValuePair value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair[] $keyValuePair
     * @return \ArrayType\ArrayOfKeyValuePair
     */
    public function setKeyValuePair(array $keyValuePair = array())
    {
        // validation for constraint: array
        if ('' !== ($keyValuePairArrayErrorMessage = self::validateKeyValuePairForArrayConstraintsFromSetKeyValuePair($keyValuePair))) {
            throw new \InvalidArgumentException($keyValuePairArrayErrorMessage, __LINE__);
        }
        if (is_null($keyValuePair) || (is_array($keyValuePair) && empty($keyValuePair))) {
            unset($this->KeyValuePair);
        } else {
            $this->KeyValuePair = $keyValuePair;
        }
        return $this;
    }
    /**
     * Add item to KeyValuePair value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair $item
     * @return \ArrayType\ArrayOfKeyValuePair
     */
    public function addToKeyValuePair(\StructType\KeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The KeyValuePair property can only contain items of type \StructType\KeyValuePair, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KeyValuePair[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\KeyValuePair|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\KeyValuePair|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\KeyValuePair|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\KeyValuePair|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\KeyValuePair|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string KeyValuePair
     */
    public function getAttributeName()
    {
        return 'KeyValuePair';
    }
}
