<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomFieldValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomFieldValue extends AbstractStructArrayBase
{
    /**
     * The CustomFieldValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomFieldValue[]
     */
    public $CustomFieldValue;
    /**
     * Constructor method for ArrayOfCustomFieldValue
     * @uses ArrayOfCustomFieldValue::setCustomFieldValue()
     * @param \StructType\CustomFieldValue[] $customFieldValue
     */
    public function __construct(array $customFieldValue = array())
    {
        $this
            ->setCustomFieldValue($customFieldValue);
    }
    /**
     * Get CustomFieldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomFieldValue[]|null
     */
    public function getCustomFieldValue()
    {
        return isset($this->CustomFieldValue) ? $this->CustomFieldValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldValueForArrayConstraintsFromSetCustomFieldValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomFieldValueCustomFieldValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomFieldValueCustomFieldValueItem instanceof \StructType\CustomFieldValue) {
                $invalidValues[] = is_object($arrayOfCustomFieldValueCustomFieldValueItem) ? get_class($arrayOfCustomFieldValueCustomFieldValueItem) : sprintf('%s(%s)', gettype($arrayOfCustomFieldValueCustomFieldValueItem), var_export($arrayOfCustomFieldValueCustomFieldValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldValue property can only contain items of type \StructType\CustomFieldValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldValue[] $customFieldValue
     * @return \ArrayType\ArrayOfCustomFieldValue
     */
    public function setCustomFieldValue(array $customFieldValue = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldValueArrayErrorMessage = self::validateCustomFieldValueForArrayConstraintsFromSetCustomFieldValue($customFieldValue))) {
            throw new \InvalidArgumentException($customFieldValueArrayErrorMessage, __LINE__);
        }
        if (is_null($customFieldValue) || (is_array($customFieldValue) && empty($customFieldValue))) {
            unset($this->CustomFieldValue);
        } else {
            $this->CustomFieldValue = $customFieldValue;
        }
        return $this;
    }
    /**
     * Add item to CustomFieldValue value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldValue $item
     * @return \ArrayType\ArrayOfCustomFieldValue
     */
    public function addToCustomFieldValue(\StructType\CustomFieldValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldValue) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldValue property can only contain items of type \StructType\CustomFieldValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomFieldValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomFieldValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomFieldValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomFieldValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomFieldValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomFieldValue
     */
    public function getAttributeName()
    {
        return 'CustomFieldValue';
    }
}
