<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomFieldInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomFieldInfo extends AbstractStructArrayBase
{
    /**
     * The CustomFieldInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomFieldInfo[]
     */
    public $CustomFieldInfo;
    /**
     * Constructor method for ArrayOfCustomFieldInfo
     * @uses ArrayOfCustomFieldInfo::setCustomFieldInfo()
     * @param \StructType\CustomFieldInfo[] $customFieldInfo
     */
    public function __construct(array $customFieldInfo = array())
    {
        $this
            ->setCustomFieldInfo($customFieldInfo);
    }
    /**
     * Get CustomFieldInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomFieldInfo[]|null
     */
    public function getCustomFieldInfo()
    {
        return isset($this->CustomFieldInfo) ? $this->CustomFieldInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldInfoForArrayConstraintsFromSetCustomFieldInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomFieldInfoCustomFieldInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomFieldInfoCustomFieldInfoItem instanceof \StructType\CustomFieldInfo) {
                $invalidValues[] = is_object($arrayOfCustomFieldInfoCustomFieldInfoItem) ? get_class($arrayOfCustomFieldInfoCustomFieldInfoItem) : sprintf('%s(%s)', gettype($arrayOfCustomFieldInfoCustomFieldInfoItem), var_export($arrayOfCustomFieldInfoCustomFieldInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldInfo property can only contain items of type \StructType\CustomFieldInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldInfo[] $customFieldInfo
     * @return \ArrayType\ArrayOfCustomFieldInfo
     */
    public function setCustomFieldInfo(array $customFieldInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldInfoArrayErrorMessage = self::validateCustomFieldInfoForArrayConstraintsFromSetCustomFieldInfo($customFieldInfo))) {
            throw new \InvalidArgumentException($customFieldInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($customFieldInfo) || (is_array($customFieldInfo) && empty($customFieldInfo))) {
            unset($this->CustomFieldInfo);
        } else {
            $this->CustomFieldInfo = $customFieldInfo;
        }
        return $this;
    }
    /**
     * Add item to CustomFieldInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldInfo $item
     * @return \ArrayType\ArrayOfCustomFieldInfo
     */
    public function addToCustomFieldInfo(\StructType\CustomFieldInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldInfo) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldInfo property can only contain items of type \StructType\CustomFieldInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomFieldInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomFieldInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomFieldInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomFieldInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomFieldInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomFieldInfo
     */
    public function getAttributeName()
    {
        return 'CustomFieldInfo';
    }
}
