<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfAccountInfo extends AbstractStructArrayBase
{
    /**
     * The AccountInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountInfo[]
     */
    public $AccountInfo;
    /**
     * Constructor method for ArrayOfAccountInfo
     * @uses ArrayOfAccountInfo::setAccountInfo()
     * @param \StructType\AccountInfo[] $accountInfo
     */
    public function __construct(array $accountInfo = array())
    {
        $this
            ->setAccountInfo($accountInfo);
    }
    /**
     * Get AccountInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountInfo[]|null
     */
    public function getAccountInfo()
    {
        return isset($this->AccountInfo) ? $this->AccountInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountInfoForArrayConstraintsFromSetAccountInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountInfoAccountInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountInfoAccountInfoItem instanceof \StructType\AccountInfo) {
                $invalidValues[] = is_object($arrayOfAccountInfoAccountInfoItem) ? get_class($arrayOfAccountInfoAccountInfoItem) : sprintf('%s(%s)', gettype($arrayOfAccountInfoAccountInfoItem), var_export($arrayOfAccountInfoAccountInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountInfo property can only contain items of type \StructType\AccountInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountInfo[] $accountInfo
     * @return \ArrayType\ArrayOfAccountInfo
     */
    public function setAccountInfo(array $accountInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($accountInfoArrayErrorMessage = self::validateAccountInfoForArrayConstraintsFromSetAccountInfo($accountInfo))) {
            throw new \InvalidArgumentException($accountInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($accountInfo) || (is_array($accountInfo) && empty($accountInfo))) {
            unset($this->AccountInfo);
        } else {
            $this->AccountInfo = $accountInfo;
        }
        return $this;
    }
    /**
     * Add item to AccountInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountInfo $item
     * @return \ArrayType\ArrayOfAccountInfo
     */
    public function addToAccountInfo(\StructType\AccountInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountInfo) {
            throw new \InvalidArgumentException(sprintf('The AccountInfo property can only contain items of type \StructType\AccountInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountInfo
     */
    public function getAttributeName()
    {
        return 'AccountInfo';
    }
}
