<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGLAccountRequest StructType
 * @subpackage Structs
 */
class UpdateGLAccountRequest extends TipaltiGLAccount
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The PayerEntities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PayerEntities;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Category;
    /**
     * Constructor method for UpdateGLAccountRequest
     * @uses UpdateGLAccountRequest::setAction()
     * @uses UpdateGLAccountRequest::setPayerEntities()
     * @uses UpdateGLAccountRequest::setCategory()
     * @param string $action
     * @param \ArrayType\ArrayOfString $payerEntities
     * @param \ArrayType\ArrayOfString $category
     */
    public function __construct($action = null, \ArrayType\ArrayOfString $payerEntities = null, \ArrayType\ArrayOfString $category = null)
    {
        $this
            ->setAction($action)
            ->setPayerEntities($payerEntities)
            ->setCategory($category);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\TipaltiGlAccountAction::valueIsValid()
     * @uses \EnumType\TipaltiGlAccountAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\UpdateGLAccountRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipaltiGlAccountAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipaltiGlAccountAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\TipaltiGlAccountAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get PayerEntities value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPayerEntities()
    {
        return $this->PayerEntities;
    }
    /**
     * Set PayerEntities value
     * @param \ArrayType\ArrayOfString $payerEntities
     * @return \StructType\UpdateGLAccountRequest
     */
    public function setPayerEntities(\ArrayType\ArrayOfString $payerEntities = null)
    {
        $this->PayerEntities = $payerEntities;
        return $this;
    }
    /**
     * Get Category value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \ArrayType\ArrayOfString $category
     * @return \StructType\UpdateGLAccountRequest
     */
    public function setCategory(\ArrayType\ArrayOfString $category = null)
    {
        $this->Category = $category;
        return $this;
    }
}
