<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiVendorCredit StructType
 * @subpackage Structs
 */
class TipaltiVendorCredit extends AbstractStructBase
{
    /**
     * The AppliedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AppliedAmount;
    /**
     * The RefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefCode;
    /**
     * Constructor method for TipaltiVendorCredit
     * @uses TipaltiVendorCredit::setAppliedAmount()
     * @uses TipaltiVendorCredit::setRefCode()
     * @param float $appliedAmount
     * @param string $refCode
     */
    public function __construct($appliedAmount = null, $refCode = null)
    {
        $this
            ->setAppliedAmount($appliedAmount)
            ->setRefCode($refCode);
    }
    /**
     * Get AppliedAmount value
     * @return float
     */
    public function getAppliedAmount()
    {
        return $this->AppliedAmount;
    }
    /**
     * Set AppliedAmount value
     * @param float $appliedAmount
     * @return \StructType\TipaltiVendorCredit
     */
    public function setAppliedAmount($appliedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($appliedAmount) && !(is_float($appliedAmount) || is_numeric($appliedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($appliedAmount, true), gettype($appliedAmount)), __LINE__);
        }
        $this->AppliedAmount = $appliedAmount;
        return $this;
    }
    /**
     * Get RefCode value
     * @return string|null
     */
    public function getRefCode()
    {
        return $this->RefCode;
    }
    /**
     * Set RefCode value
     * @param string $refCode
     * @return \StructType\TipaltiVendorCredit
     */
    public function setRefCode($refCode = null)
    {
        // validation for constraint: string
        if (!is_null($refCode) && !is_string($refCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCode, true), gettype($refCode)), __LINE__);
        }
        $this->RefCode = $refCode;
        return $this;
    }
}
