<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiPurchaseOrderItemResult StructType
 * @subpackage Structs
 */
class TipaltiPurchaseOrderItemResult extends AbstractStructBase
{
    /**
     * The Succeeded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Succeeded;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * Constructor method for TipaltiPurchaseOrderItemResult
     * @uses TipaltiPurchaseOrderItemResult::setSucceeded()
     * @uses TipaltiPurchaseOrderItemResult::setErrorMessage()
     * @uses TipaltiPurchaseOrderItemResult::setPurchaseOrderNumber()
     * @param bool $succeeded
     * @param string $errorMessage
     * @param string $purchaseOrderNumber
     */
    public function __construct($succeeded = null, $errorMessage = null, $purchaseOrderNumber = null)
    {
        $this
            ->setSucceeded($succeeded)
            ->setErrorMessage($errorMessage)
            ->setPurchaseOrderNumber($purchaseOrderNumber);
    }
    /**
     * Get Succeeded value
     * @return bool
     */
    public function getSucceeded()
    {
        return $this->Succeeded;
    }
    /**
     * Set Succeeded value
     * @param bool $succeeded
     * @return \StructType\TipaltiPurchaseOrderItemResult
     */
    public function setSucceeded($succeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($succeeded) && !is_bool($succeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($succeeded, true), gettype($succeeded)), __LINE__);
        }
        $this->Succeeded = $succeeded;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiPurchaseOrderItemResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\TipaltiPurchaseOrderItemResult
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
}
