<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiPurchaseOrderItem StructType
 * @subpackage Structs
 */
class TipaltiPurchaseOrderItem extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The PurchaseOrderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PurchaseOrderDate;
    /**
     * The Idap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Idap;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The PayerEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntity;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Approvers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiInvoiceApprover
     */
    public $Approvers;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $CustomFields;
    /**
     * The PurchaseOrderLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPurchaseOrderLine
     */
    public $PurchaseOrderLines;
    /**
     * Constructor method for TipaltiPurchaseOrderItem
     * @uses TipaltiPurchaseOrderItem::setStatus()
     * @uses TipaltiPurchaseOrderItem::setPurchaseOrderDate()
     * @uses TipaltiPurchaseOrderItem::setIdap()
     * @uses TipaltiPurchaseOrderItem::setPurchaseOrderNumber()
     * @uses TipaltiPurchaseOrderItem::setMemo()
     * @uses TipaltiPurchaseOrderItem::setPayerEntity()
     * @uses TipaltiPurchaseOrderItem::setCurrency()
     * @uses TipaltiPurchaseOrderItem::setApprovers()
     * @uses TipaltiPurchaseOrderItem::setCustomFields()
     * @uses TipaltiPurchaseOrderItem::setPurchaseOrderLines()
     * @param string $status
     * @param string $purchaseOrderDate
     * @param string $idap
     * @param string $purchaseOrderNumber
     * @param string $memo
     * @param string $payerEntity
     * @param string $currency
     * @param \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @param \ArrayType\ArrayOfPurchaseOrderLine $purchaseOrderLines
     */
    public function __construct($status = null, $purchaseOrderDate = null, $idap = null, $purchaseOrderNumber = null, $memo = null, $payerEntity = null, $currency = null, \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers = null, \ArrayType\ArrayOfKeyValuePair $customFields = null, \ArrayType\ArrayOfPurchaseOrderLine $purchaseOrderLines = null)
    {
        $this
            ->setStatus($status)
            ->setPurchaseOrderDate($purchaseOrderDate)
            ->setIdap($idap)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setMemo($memo)
            ->setPayerEntity($payerEntity)
            ->setCurrency($currency)
            ->setApprovers($approvers)
            ->setCustomFields($customFields)
            ->setPurchaseOrderLines($purchaseOrderLines);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EUploadCenterRecordStatus::valueIsValid()
     * @uses \EnumType\EUploadCenterRecordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EUploadCenterRecordStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EUploadCenterRecordStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EUploadCenterRecordStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PurchaseOrderDate value
     * @return string
     */
    public function getPurchaseOrderDate()
    {
        return $this->PurchaseOrderDate;
    }
    /**
     * Set PurchaseOrderDate value
     * @param string $purchaseOrderDate
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setPurchaseOrderDate($purchaseOrderDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderDate) && !is_string($purchaseOrderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderDate, true), gettype($purchaseOrderDate)), __LINE__);
        }
        $this->PurchaseOrderDate = $purchaseOrderDate;
        return $this;
    }
    /**
     * Get Idap value
     * @return string|null
     */
    public function getIdap()
    {
        return $this->Idap;
    }
    /**
     * Set Idap value
     * @param string $idap
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setIdap($idap = null)
    {
        // validation for constraint: string
        if (!is_null($idap) && !is_string($idap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idap, true), gettype($idap)), __LINE__);
        }
        $this->Idap = $idap;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get PayerEntity value
     * @return string|null
     */
    public function getPayerEntity()
    {
        return $this->PayerEntity;
    }
    /**
     * Set PayerEntity value
     * @param string $payerEntity
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setPayerEntity($payerEntity = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntity) && !is_string($payerEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntity, true), gettype($payerEntity)), __LINE__);
        }
        $this->PayerEntity = $payerEntity;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Approvers value
     * @return \ArrayType\ArrayOfTipaltiInvoiceApprover|null
     */
    public function getApprovers()
    {
        return $this->Approvers;
    }
    /**
     * Set Approvers value
     * @param \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setApprovers(\ArrayType\ArrayOfTipaltiInvoiceApprover $approvers = null)
    {
        $this->Approvers = $approvers;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setCustomFields(\ArrayType\ArrayOfKeyValuePair $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get PurchaseOrderLines value
     * @return \ArrayType\ArrayOfPurchaseOrderLine|null
     */
    public function getPurchaseOrderLines()
    {
        return $this->PurchaseOrderLines;
    }
    /**
     * Set PurchaseOrderLines value
     * @param \ArrayType\ArrayOfPurchaseOrderLine $purchaseOrderLines
     * @return \StructType\TipaltiPurchaseOrderItem
     */
    public function setPurchaseOrderLines(\ArrayType\ArrayOfPurchaseOrderLine $purchaseOrderLines = null)
    {
        $this->PurchaseOrderLines = $purchaseOrderLines;
        return $this;
    }
}
