<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiProcessPaymentResponse StructType
 * @subpackage Structs
 */
class TipaltiProcessPaymentResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The LineErrorsOrWarning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLineErrorOrWarning
     */
    public $LineErrorsOrWarning;
    /**
     * The resultsFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resultsFile;
    /**
     * Constructor method for TipaltiProcessPaymentResponse
     * @uses TipaltiProcessPaymentResponse::setErrorCode()
     * @uses TipaltiProcessPaymentResponse::setErrorMessage()
     * @uses TipaltiProcessPaymentResponse::setLineErrorsOrWarning()
     * @uses TipaltiProcessPaymentResponse::setResultsFile()
     * @param string $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfLineErrorOrWarning $lineErrorsOrWarning
     * @param string $resultsFile
     */
    public function __construct($errorCode = null, $errorMessage = null, \ArrayType\ArrayOfLineErrorOrWarning $lineErrorsOrWarning = null, $resultsFile = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setLineErrorsOrWarning($lineErrorsOrWarning)
            ->setResultsFile($resultsFile);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiProcessPaymentResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiProcessPaymentResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get LineErrorsOrWarning value
     * @return \ArrayType\ArrayOfLineErrorOrWarning|null
     */
    public function getLineErrorsOrWarning()
    {
        return $this->LineErrorsOrWarning;
    }
    /**
     * Set LineErrorsOrWarning value
     * @param \ArrayType\ArrayOfLineErrorOrWarning $lineErrorsOrWarning
     * @return \StructType\TipaltiProcessPaymentResponse
     */
    public function setLineErrorsOrWarning(\ArrayType\ArrayOfLineErrorOrWarning $lineErrorsOrWarning = null)
    {
        $this->LineErrorsOrWarning = $lineErrorsOrWarning;
        return $this;
    }
    /**
     * Get resultsFile value
     * @return string|null
     */
    public function getResultsFile()
    {
        return $this->resultsFile;
    }
    /**
     * Set resultsFile value
     * @param string $resultsFile
     * @return \StructType\TipaltiProcessPaymentResponse
     */
    public function setResultsFile($resultsFile = null)
    {
        // validation for constraint: string
        if (!is_null($resultsFile) && !is_string($resultsFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultsFile, true), gettype($resultsFile)), __LINE__);
        }
        $this->resultsFile = $resultsFile;
        return $this;
    }
}
