<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiPaymentOrderItem StructType
 * @subpackage Structs
 */
class TipaltiPaymentOrderItem extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The IgnoreThresholds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IgnoreThresholds;
    /**
     * The ScheduledDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ScheduledDate;
    /**
     * The IsScheduledVisible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsScheduledVisible;
    /**
     * The IgnoreRiskCases
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IgnoreRiskCases;
    /**
     * The IgnoreTaxValidation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IgnoreTaxValidation;
    /**
     * The MaxWithholding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MaxWithholding;
    /**
     * The TreatyLimitExceeded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $TreatyLimitExceeded;
    /**
     * The Idap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Idap;
    /**
     * The RefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefCode;
    /**
     * The EWalletMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EWalletMessage;
    /**
     * The BankingMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankingMessage;
    /**
     * The EmailMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailMessage;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $CustomFields;
    /**
     * The IncomeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncomeType;
    /**
     * Constructor method for TipaltiPaymentOrderItem
     * @uses TipaltiPaymentOrderItem::setAmount()
     * @uses TipaltiPaymentOrderItem::setIgnoreThresholds()
     * @uses TipaltiPaymentOrderItem::setScheduledDate()
     * @uses TipaltiPaymentOrderItem::setIsScheduledVisible()
     * @uses TipaltiPaymentOrderItem::setIgnoreRiskCases()
     * @uses TipaltiPaymentOrderItem::setIgnoreTaxValidation()
     * @uses TipaltiPaymentOrderItem::setMaxWithholding()
     * @uses TipaltiPaymentOrderItem::setTreatyLimitExceeded()
     * @uses TipaltiPaymentOrderItem::setIdap()
     * @uses TipaltiPaymentOrderItem::setRefCode()
     * @uses TipaltiPaymentOrderItem::setEWalletMessage()
     * @uses TipaltiPaymentOrderItem::setBankingMessage()
     * @uses TipaltiPaymentOrderItem::setEmailMessage()
     * @uses TipaltiPaymentOrderItem::setCurrency()
     * @uses TipaltiPaymentOrderItem::setCustomFields()
     * @uses TipaltiPaymentOrderItem::setIncomeType()
     * @param float $amount
     * @param bool $ignoreThresholds
     * @param string $scheduledDate
     * @param bool $isScheduledVisible
     * @param bool $ignoreRiskCases
     * @param bool $ignoreTaxValidation
     * @param bool $maxWithholding
     * @param bool $treatyLimitExceeded
     * @param string $idap
     * @param string $refCode
     * @param string $eWalletMessage
     * @param string $bankingMessage
     * @param string $emailMessage
     * @param string $currency
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @param string $incomeType
     */
    public function __construct($amount = null, $ignoreThresholds = null, $scheduledDate = null, $isScheduledVisible = null, $ignoreRiskCases = null, $ignoreTaxValidation = null, $maxWithholding = null, $treatyLimitExceeded = null, $idap = null, $refCode = null, $eWalletMessage = null, $bankingMessage = null, $emailMessage = null, $currency = null, \ArrayType\ArrayOfKeyValuePair $customFields = null, $incomeType = null)
    {
        $this
            ->setAmount($amount)
            ->setIgnoreThresholds($ignoreThresholds)
            ->setScheduledDate($scheduledDate)
            ->setIsScheduledVisible($isScheduledVisible)
            ->setIgnoreRiskCases($ignoreRiskCases)
            ->setIgnoreTaxValidation($ignoreTaxValidation)
            ->setMaxWithholding($maxWithholding)
            ->setTreatyLimitExceeded($treatyLimitExceeded)
            ->setIdap($idap)
            ->setRefCode($refCode)
            ->setEWalletMessage($eWalletMessage)
            ->setBankingMessage($bankingMessage)
            ->setEmailMessage($emailMessage)
            ->setCurrency($currency)
            ->setCustomFields($customFields)
            ->setIncomeType($incomeType);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get IgnoreThresholds value
     * @return bool
     */
    public function getIgnoreThresholds()
    {
        return $this->IgnoreThresholds;
    }
    /**
     * Set IgnoreThresholds value
     * @param bool $ignoreThresholds
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setIgnoreThresholds($ignoreThresholds = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreThresholds) && !is_bool($ignoreThresholds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreThresholds, true), gettype($ignoreThresholds)), __LINE__);
        }
        $this->IgnoreThresholds = $ignoreThresholds;
        return $this;
    }
    /**
     * Get ScheduledDate value
     * @return string
     */
    public function getScheduledDate()
    {
        return $this->ScheduledDate;
    }
    /**
     * Set ScheduledDate value
     * @param string $scheduledDate
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setScheduledDate($scheduledDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDate) && !is_string($scheduledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledDate, true), gettype($scheduledDate)), __LINE__);
        }
        $this->ScheduledDate = $scheduledDate;
        return $this;
    }
    /**
     * Get IsScheduledVisible value
     * @return bool
     */
    public function getIsScheduledVisible()
    {
        return $this->IsScheduledVisible;
    }
    /**
     * Set IsScheduledVisible value
     * @param bool $isScheduledVisible
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setIsScheduledVisible($isScheduledVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isScheduledVisible) && !is_bool($isScheduledVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isScheduledVisible, true), gettype($isScheduledVisible)), __LINE__);
        }
        $this->IsScheduledVisible = $isScheduledVisible;
        return $this;
    }
    /**
     * Get IgnoreRiskCases value
     * @return bool
     */
    public function getIgnoreRiskCases()
    {
        return $this->IgnoreRiskCases;
    }
    /**
     * Set IgnoreRiskCases value
     * @param bool $ignoreRiskCases
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setIgnoreRiskCases($ignoreRiskCases = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreRiskCases) && !is_bool($ignoreRiskCases)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreRiskCases, true), gettype($ignoreRiskCases)), __LINE__);
        }
        $this->IgnoreRiskCases = $ignoreRiskCases;
        return $this;
    }
    /**
     * Get IgnoreTaxValidation value
     * @return bool
     */
    public function getIgnoreTaxValidation()
    {
        return $this->IgnoreTaxValidation;
    }
    /**
     * Set IgnoreTaxValidation value
     * @param bool $ignoreTaxValidation
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setIgnoreTaxValidation($ignoreTaxValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreTaxValidation) && !is_bool($ignoreTaxValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreTaxValidation, true), gettype($ignoreTaxValidation)), __LINE__);
        }
        $this->IgnoreTaxValidation = $ignoreTaxValidation;
        return $this;
    }
    /**
     * Get MaxWithholding value
     * @return bool
     */
    public function getMaxWithholding()
    {
        return $this->MaxWithholding;
    }
    /**
     * Set MaxWithholding value
     * @param bool $maxWithholding
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setMaxWithholding($maxWithholding = null)
    {
        // validation for constraint: boolean
        if (!is_null($maxWithholding) && !is_bool($maxWithholding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maxWithholding, true), gettype($maxWithholding)), __LINE__);
        }
        $this->MaxWithholding = $maxWithholding;
        return $this;
    }
    /**
     * Get TreatyLimitExceeded value
     * @return bool
     */
    public function getTreatyLimitExceeded()
    {
        return $this->TreatyLimitExceeded;
    }
    /**
     * Set TreatyLimitExceeded value
     * @param bool $treatyLimitExceeded
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setTreatyLimitExceeded($treatyLimitExceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($treatyLimitExceeded) && !is_bool($treatyLimitExceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($treatyLimitExceeded, true), gettype($treatyLimitExceeded)), __LINE__);
        }
        $this->TreatyLimitExceeded = $treatyLimitExceeded;
        return $this;
    }
    /**
     * Get Idap value
     * @return string|null
     */
    public function getIdap()
    {
        return $this->Idap;
    }
    /**
     * Set Idap value
     * @param string $idap
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setIdap($idap = null)
    {
        // validation for constraint: string
        if (!is_null($idap) && !is_string($idap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idap, true), gettype($idap)), __LINE__);
        }
        $this->Idap = $idap;
        return $this;
    }
    /**
     * Get RefCode value
     * @return string|null
     */
    public function getRefCode()
    {
        return $this->RefCode;
    }
    /**
     * Set RefCode value
     * @param string $refCode
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setRefCode($refCode = null)
    {
        // validation for constraint: string
        if (!is_null($refCode) && !is_string($refCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCode, true), gettype($refCode)), __LINE__);
        }
        $this->RefCode = $refCode;
        return $this;
    }
    /**
     * Get EWalletMessage value
     * @return string|null
     */
    public function getEWalletMessage()
    {
        return $this->EWalletMessage;
    }
    /**
     * Set EWalletMessage value
     * @param string $eWalletMessage
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setEWalletMessage($eWalletMessage = null)
    {
        // validation for constraint: string
        if (!is_null($eWalletMessage) && !is_string($eWalletMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eWalletMessage, true), gettype($eWalletMessage)), __LINE__);
        }
        $this->EWalletMessage = $eWalletMessage;
        return $this;
    }
    /**
     * Get BankingMessage value
     * @return string|null
     */
    public function getBankingMessage()
    {
        return $this->BankingMessage;
    }
    /**
     * Set BankingMessage value
     * @param string $bankingMessage
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setBankingMessage($bankingMessage = null)
    {
        // validation for constraint: string
        if (!is_null($bankingMessage) && !is_string($bankingMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankingMessage, true), gettype($bankingMessage)), __LINE__);
        }
        $this->BankingMessage = $bankingMessage;
        return $this;
    }
    /**
     * Get EmailMessage value
     * @return string|null
     */
    public function getEmailMessage()
    {
        return $this->EmailMessage;
    }
    /**
     * Set EmailMessage value
     * @param string $emailMessage
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setEmailMessage($emailMessage = null)
    {
        // validation for constraint: string
        if (!is_null($emailMessage) && !is_string($emailMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailMessage, true), gettype($emailMessage)), __LINE__);
        }
        $this->EmailMessage = $emailMessage;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setCustomFields(\ArrayType\ArrayOfKeyValuePair $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get IncomeType value
     * @return string|null
     */
    public function getIncomeType()
    {
        return $this->IncomeType;
    }
    /**
     * Set IncomeType value
     * @param string $incomeType
     * @return \StructType\TipaltiPaymentOrderItem
     */
    public function setIncomeType($incomeType = null)
    {
        // validation for constraint: string
        if (!is_null($incomeType) && !is_string($incomeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomeType, true), gettype($incomeType)), __LINE__);
        }
        $this->IncomeType = $incomeType;
        return $this;
    }
}
