<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiInvoiceItemResponse StructType
 * @subpackage Structs
 */
class TipaltiInvoiceItemResponse extends AbstractStructBase
{
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDueDate;
    /**
     * The CanApprove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanApprove;
    /**
     * The IsPaidManually
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPaidManually;
    /**
     * The InvoiceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InvoiceStatus;
    /**
     * The ApprovalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApprovalDate;
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountDue;
    /**
     * The PurchaseOrderMatchingCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PurchaseOrderMatchingCompleted;
    /**
     * The HasInvoiceFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasInvoiceFile;
    /**
     * The IsInvoiceFileDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInvoiceFileDeleted;
    /**
     * The Idap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Idap;
    /**
     * The InvoiceRefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRefCode;
    /**
     * The InvoiceLines
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s1:InvoiceLines
     * @var \StructType\InvoiceLine[]
     */
    public $InvoiceLines;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The InvoiceInternalNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalNotes;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $CustomFields;
    /**
     * The IncomeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncomeType;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Approvers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiInvoiceApprover
     */
    public $Approvers;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The PayerEntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntityName;
    /**
     * The VendorCredits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiVendorCredit
     */
    public $VendorCredits;
    /**
     * The APAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TipaltiGLAccount
     */
    public $APAccount;
    /**
     * Constructor method for TipaltiInvoiceItemResponse
     * @uses TipaltiInvoiceItemResponse::setInvoiceDate()
     * @uses TipaltiInvoiceItemResponse::setInvoiceDueDate()
     * @uses TipaltiInvoiceItemResponse::setCanApprove()
     * @uses TipaltiInvoiceItemResponse::setIsPaidManually()
     * @uses TipaltiInvoiceItemResponse::setInvoiceStatus()
     * @uses TipaltiInvoiceItemResponse::setApprovalDate()
     * @uses TipaltiInvoiceItemResponse::setAmountDue()
     * @uses TipaltiInvoiceItemResponse::setPurchaseOrderMatchingCompleted()
     * @uses TipaltiInvoiceItemResponse::setHasInvoiceFile()
     * @uses TipaltiInvoiceItemResponse::setIsInvoiceFileDeleted()
     * @uses TipaltiInvoiceItemResponse::setIdap()
     * @uses TipaltiInvoiceItemResponse::setInvoiceRefCode()
     * @uses TipaltiInvoiceItemResponse::setInvoiceLines()
     * @uses TipaltiInvoiceItemResponse::setDescription()
     * @uses TipaltiInvoiceItemResponse::setInvoiceInternalNotes()
     * @uses TipaltiInvoiceItemResponse::setCustomFields()
     * @uses TipaltiInvoiceItemResponse::setIncomeType()
     * @uses TipaltiInvoiceItemResponse::setCurrency()
     * @uses TipaltiInvoiceItemResponse::setApprovers()
     * @uses TipaltiInvoiceItemResponse::setInvoiceNumber()
     * @uses TipaltiInvoiceItemResponse::setPayerEntityName()
     * @uses TipaltiInvoiceItemResponse::setVendorCredits()
     * @uses TipaltiInvoiceItemResponse::setAPAccount()
     * @param string $invoiceDate
     * @param string $invoiceDueDate
     * @param bool $canApprove
     * @param bool $isPaidManually
     * @param string $invoiceStatus
     * @param string $approvalDate
     * @param float $amountDue
     * @param bool $purchaseOrderMatchingCompleted
     * @param bool $hasInvoiceFile
     * @param bool $isInvoiceFileDeleted
     * @param string $idap
     * @param string $invoiceRefCode
     * @param \StructType\InvoiceLine[] $invoiceLines
     * @param string $description
     * @param string $invoiceInternalNotes
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @param string $incomeType
     * @param string $currency
     * @param \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers
     * @param string $invoiceNumber
     * @param string $payerEntityName
     * @param \ArrayType\ArrayOfTipaltiVendorCredit $vendorCredits
     * @param \StructType\TipaltiGLAccount $aPAccount
     */
    public function __construct($invoiceDate = null, $invoiceDueDate = null, $canApprove = null, $isPaidManually = null, $invoiceStatus = null, $approvalDate = null, $amountDue = null, $purchaseOrderMatchingCompleted = null, $hasInvoiceFile = null, $isInvoiceFileDeleted = null, $idap = null, $invoiceRefCode = null, array $invoiceLines = array(), $description = null, $invoiceInternalNotes = null, \ArrayType\ArrayOfKeyValuePair $customFields = null, $incomeType = null, $currency = null, \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers = null, $invoiceNumber = null, $payerEntityName = null, \ArrayType\ArrayOfTipaltiVendorCredit $vendorCredits = null, \StructType\TipaltiGLAccount $aPAccount = null)
    {
        $this
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceDueDate($invoiceDueDate)
            ->setCanApprove($canApprove)
            ->setIsPaidManually($isPaidManually)
            ->setInvoiceStatus($invoiceStatus)
            ->setApprovalDate($approvalDate)
            ->setAmountDue($amountDue)
            ->setPurchaseOrderMatchingCompleted($purchaseOrderMatchingCompleted)
            ->setHasInvoiceFile($hasInvoiceFile)
            ->setIsInvoiceFileDeleted($isInvoiceFileDeleted)
            ->setIdap($idap)
            ->setInvoiceRefCode($invoiceRefCode)
            ->setInvoiceLines($invoiceLines)
            ->setDescription($description)
            ->setInvoiceInternalNotes($invoiceInternalNotes)
            ->setCustomFields($customFields)
            ->setIncomeType($incomeType)
            ->setCurrency($currency)
            ->setApprovers($approvers)
            ->setInvoiceNumber($invoiceNumber)
            ->setPayerEntityName($payerEntityName)
            ->setVendorCredits($vendorCredits)
            ->setAPAccount($aPAccount);
    }
    /**
     * Get InvoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceDueDate value
     * @return string
     */
    public function getInvoiceDueDate()
    {
        return $this->InvoiceDueDate;
    }
    /**
     * Set InvoiceDueDate value
     * @param string $invoiceDueDate
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceDueDate($invoiceDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDueDate) && !is_string($invoiceDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDueDate, true), gettype($invoiceDueDate)), __LINE__);
        }
        $this->InvoiceDueDate = $invoiceDueDate;
        return $this;
    }
    /**
     * Get CanApprove value
     * @return bool
     */
    public function getCanApprove()
    {
        return $this->CanApprove;
    }
    /**
     * Set CanApprove value
     * @param bool $canApprove
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setCanApprove($canApprove = null)
    {
        // validation for constraint: boolean
        if (!is_null($canApprove) && !is_bool($canApprove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canApprove, true), gettype($canApprove)), __LINE__);
        }
        $this->CanApprove = $canApprove;
        return $this;
    }
    /**
     * Get IsPaidManually value
     * @return bool
     */
    public function getIsPaidManually()
    {
        return $this->IsPaidManually;
    }
    /**
     * Set IsPaidManually value
     * @param bool $isPaidManually
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setIsPaidManually($isPaidManually = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaidManually) && !is_bool($isPaidManually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaidManually, true), gettype($isPaidManually)), __LINE__);
        }
        $this->IsPaidManually = $isPaidManually;
        return $this;
    }
    /**
     * Get InvoiceStatus value
     * @return string
     */
    public function getInvoiceStatus()
    {
        return $this->InvoiceStatus;
    }
    /**
     * Set InvoiceStatus value
     * @uses \EnumType\TipaltiInvoiceStatus::valueIsValid()
     * @uses \EnumType\TipaltiInvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceStatus
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceStatus($invoiceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipaltiInvoiceStatus::valueIsValid($invoiceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipaltiInvoiceStatus', is_array($invoiceStatus) ? implode(', ', $invoiceStatus) : var_export($invoiceStatus, true), implode(', ', \EnumType\TipaltiInvoiceStatus::getValidValues())), __LINE__);
        }
        $this->InvoiceStatus = $invoiceStatus;
        return $this;
    }
    /**
     * Get ApprovalDate value
     * @return string
     */
    public function getApprovalDate()
    {
        return $this->ApprovalDate;
    }
    /**
     * Set ApprovalDate value
     * @param string $approvalDate
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setApprovalDate($approvalDate = null)
    {
        // validation for constraint: string
        if (!is_null($approvalDate) && !is_string($approvalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalDate, true), gettype($approvalDate)), __LINE__);
        }
        $this->ApprovalDate = $approvalDate;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get PurchaseOrderMatchingCompleted value
     * @return bool
     */
    public function getPurchaseOrderMatchingCompleted()
    {
        return $this->PurchaseOrderMatchingCompleted;
    }
    /**
     * Set PurchaseOrderMatchingCompleted value
     * @param bool $purchaseOrderMatchingCompleted
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setPurchaseOrderMatchingCompleted($purchaseOrderMatchingCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchaseOrderMatchingCompleted) && !is_bool($purchaseOrderMatchingCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchaseOrderMatchingCompleted, true), gettype($purchaseOrderMatchingCompleted)), __LINE__);
        }
        $this->PurchaseOrderMatchingCompleted = $purchaseOrderMatchingCompleted;
        return $this;
    }
    /**
     * Get HasInvoiceFile value
     * @return bool
     */
    public function getHasInvoiceFile()
    {
        return $this->HasInvoiceFile;
    }
    /**
     * Set HasInvoiceFile value
     * @param bool $hasInvoiceFile
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setHasInvoiceFile($hasInvoiceFile = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasInvoiceFile) && !is_bool($hasInvoiceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasInvoiceFile, true), gettype($hasInvoiceFile)), __LINE__);
        }
        $this->HasInvoiceFile = $hasInvoiceFile;
        return $this;
    }
    /**
     * Get IsInvoiceFileDeleted value
     * @return bool
     */
    public function getIsInvoiceFileDeleted()
    {
        return $this->IsInvoiceFileDeleted;
    }
    /**
     * Set IsInvoiceFileDeleted value
     * @param bool $isInvoiceFileDeleted
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setIsInvoiceFileDeleted($isInvoiceFileDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInvoiceFileDeleted) && !is_bool($isInvoiceFileDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInvoiceFileDeleted, true), gettype($isInvoiceFileDeleted)), __LINE__);
        }
        $this->IsInvoiceFileDeleted = $isInvoiceFileDeleted;
        return $this;
    }
    /**
     * Get Idap value
     * @return string|null
     */
    public function getIdap()
    {
        return $this->Idap;
    }
    /**
     * Set Idap value
     * @param string $idap
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setIdap($idap = null)
    {
        // validation for constraint: string
        if (!is_null($idap) && !is_string($idap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idap, true), gettype($idap)), __LINE__);
        }
        $this->Idap = $idap;
        return $this;
    }
    /**
     * Get InvoiceRefCode value
     * @return string|null
     */
    public function getInvoiceRefCode()
    {
        return $this->InvoiceRefCode;
    }
    /**
     * Set InvoiceRefCode value
     * @param string $invoiceRefCode
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceRefCode($invoiceRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRefCode) && !is_string($invoiceRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRefCode, true), gettype($invoiceRefCode)), __LINE__);
        }
        $this->InvoiceRefCode = $invoiceRefCode;
        return $this;
    }
    /**
     * Get InvoiceLines value
     * @return \StructType\InvoiceLine[]|null
     */
    public function getInvoiceLines()
    {
        return $this->InvoiceLines;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLinesForArrayConstraintsFromSetInvoiceLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tipaltiInvoiceItemResponseInvoiceLinesItem) {
            // validation for constraint: itemType
            if (!$tipaltiInvoiceItemResponseInvoiceLinesItem instanceof \StructType\InvoiceLine) {
                $invalidValues[] = is_object($tipaltiInvoiceItemResponseInvoiceLinesItem) ? get_class($tipaltiInvoiceItemResponseInvoiceLinesItem) : sprintf('%s(%s)', gettype($tipaltiInvoiceItemResponseInvoiceLinesItem), var_export($tipaltiInvoiceItemResponseInvoiceLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLines property can only contain items of type \StructType\InvoiceLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLines value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceLine[] $invoiceLines
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceLines(array $invoiceLines = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLinesArrayErrorMessage = self::validateInvoiceLinesForArrayConstraintsFromSetInvoiceLines($invoiceLines))) {
            throw new \InvalidArgumentException($invoiceLinesArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLines = $invoiceLines;
        return $this;
    }
    /**
     * Add item to InvoiceLines value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceLine $item
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function addToInvoiceLines(\StructType\InvoiceLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceLine) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLines property can only contain items of type \StructType\InvoiceLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLines[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get InvoiceInternalNotes value
     * @return string|null
     */
    public function getInvoiceInternalNotes()
    {
        return $this->InvoiceInternalNotes;
    }
    /**
     * Set InvoiceInternalNotes value
     * @param string $invoiceInternalNotes
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceInternalNotes($invoiceInternalNotes = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalNotes) && !is_string($invoiceInternalNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalNotes, true), gettype($invoiceInternalNotes)), __LINE__);
        }
        $this->InvoiceInternalNotes = $invoiceInternalNotes;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setCustomFields(\ArrayType\ArrayOfKeyValuePair $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get IncomeType value
     * @return string|null
     */
    public function getIncomeType()
    {
        return $this->IncomeType;
    }
    /**
     * Set IncomeType value
     * @param string $incomeType
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setIncomeType($incomeType = null)
    {
        // validation for constraint: string
        if (!is_null($incomeType) && !is_string($incomeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomeType, true), gettype($incomeType)), __LINE__);
        }
        $this->IncomeType = $incomeType;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Approvers value
     * @return \ArrayType\ArrayOfTipaltiInvoiceApprover|null
     */
    public function getApprovers()
    {
        return $this->Approvers;
    }
    /**
     * Set Approvers value
     * @param \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setApprovers(\ArrayType\ArrayOfTipaltiInvoiceApprover $approvers = null)
    {
        $this->Approvers = $approvers;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get PayerEntityName value
     * @return string|null
     */
    public function getPayerEntityName()
    {
        return $this->PayerEntityName;
    }
    /**
     * Set PayerEntityName value
     * @param string $payerEntityName
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setPayerEntityName($payerEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntityName) && !is_string($payerEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntityName, true), gettype($payerEntityName)), __LINE__);
        }
        $this->PayerEntityName = $payerEntityName;
        return $this;
    }
    /**
     * Get VendorCredits value
     * @return \ArrayType\ArrayOfTipaltiVendorCredit|null
     */
    public function getVendorCredits()
    {
        return $this->VendorCredits;
    }
    /**
     * Set VendorCredits value
     * @param \ArrayType\ArrayOfTipaltiVendorCredit $vendorCredits
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setVendorCredits(\ArrayType\ArrayOfTipaltiVendorCredit $vendorCredits = null)
    {
        $this->VendorCredits = $vendorCredits;
        return $this;
    }
    /**
     * Get APAccount value
     * @return \StructType\TipaltiGLAccount|null
     */
    public function getAPAccount()
    {
        return $this->APAccount;
    }
    /**
     * Set APAccount value
     * @param \StructType\TipaltiGLAccount $aPAccount
     * @return \StructType\TipaltiInvoiceItemResponse
     */
    public function setAPAccount(\StructType\TipaltiGLAccount $aPAccount = null)
    {
        $this->APAccount = $aPAccount;
        return $this;
    }
}
