<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiInvoiceItemRequest StructType
 * @subpackage Structs
 */
class TipaltiInvoiceItemRequest extends AbstractStructBase
{
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InvoiceDueDate;
    /**
     * The CanApprove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanApprove;
    /**
     * The IsPaidManually
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPaidManually;
    /**
     * The InvoiceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InvoiceStatus;
    /**
     * The Idap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Idap;
    /**
     * The InvoiceRefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRefCode;
    /**
     * The InvoiceLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceLine
     */
    public $InvoiceLines;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The InvoiceInternalNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalNotes;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $CustomFields;
    /**
     * The IncomeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncomeType;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Approvers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiInvoiceApprover
     */
    public $Approvers;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The PayerEntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntityName;
    /**
     * The InvoiceSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceSubject;
    /**
     * The ApAccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApAccountNumber;
    /**
     * The ApAccountExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApAccountExternalId;
    /**
     * Constructor method for TipaltiInvoiceItemRequest
     * @uses TipaltiInvoiceItemRequest::setInvoiceDate()
     * @uses TipaltiInvoiceItemRequest::setInvoiceDueDate()
     * @uses TipaltiInvoiceItemRequest::setCanApprove()
     * @uses TipaltiInvoiceItemRequest::setIsPaidManually()
     * @uses TipaltiInvoiceItemRequest::setInvoiceStatus()
     * @uses TipaltiInvoiceItemRequest::setIdap()
     * @uses TipaltiInvoiceItemRequest::setInvoiceRefCode()
     * @uses TipaltiInvoiceItemRequest::setInvoiceLines()
     * @uses TipaltiInvoiceItemRequest::setDescription()
     * @uses TipaltiInvoiceItemRequest::setInvoiceInternalNotes()
     * @uses TipaltiInvoiceItemRequest::setCustomFields()
     * @uses TipaltiInvoiceItemRequest::setIncomeType()
     * @uses TipaltiInvoiceItemRequest::setCurrency()
     * @uses TipaltiInvoiceItemRequest::setApprovers()
     * @uses TipaltiInvoiceItemRequest::setInvoiceNumber()
     * @uses TipaltiInvoiceItemRequest::setPayerEntityName()
     * @uses TipaltiInvoiceItemRequest::setInvoiceSubject()
     * @uses TipaltiInvoiceItemRequest::setApAccountNumber()
     * @uses TipaltiInvoiceItemRequest::setApAccountExternalId()
     * @param string $invoiceDate
     * @param string $invoiceDueDate
     * @param bool $canApprove
     * @param bool $isPaidManually
     * @param string $invoiceStatus
     * @param string $idap
     * @param string $invoiceRefCode
     * @param \ArrayType\ArrayOfInvoiceLine $invoiceLines
     * @param string $description
     * @param string $invoiceInternalNotes
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @param string $incomeType
     * @param string $currency
     * @param \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers
     * @param string $invoiceNumber
     * @param string $payerEntityName
     * @param string $invoiceSubject
     * @param string $apAccountNumber
     * @param string $apAccountExternalId
     */
    public function __construct($invoiceDate = null, $invoiceDueDate = null, $canApprove = null, $isPaidManually = null, $invoiceStatus = null, $idap = null, $invoiceRefCode = null, \ArrayType\ArrayOfInvoiceLine $invoiceLines = null, $description = null, $invoiceInternalNotes = null, \ArrayType\ArrayOfKeyValuePair $customFields = null, $incomeType = null, $currency = null, \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers = null, $invoiceNumber = null, $payerEntityName = null, $invoiceSubject = null, $apAccountNumber = null, $apAccountExternalId = null)
    {
        $this
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceDueDate($invoiceDueDate)
            ->setCanApprove($canApprove)
            ->setIsPaidManually($isPaidManually)
            ->setInvoiceStatus($invoiceStatus)
            ->setIdap($idap)
            ->setInvoiceRefCode($invoiceRefCode)
            ->setInvoiceLines($invoiceLines)
            ->setDescription($description)
            ->setInvoiceInternalNotes($invoiceInternalNotes)
            ->setCustomFields($customFields)
            ->setIncomeType($incomeType)
            ->setCurrency($currency)
            ->setApprovers($approvers)
            ->setInvoiceNumber($invoiceNumber)
            ->setPayerEntityName($payerEntityName)
            ->setInvoiceSubject($invoiceSubject)
            ->setApAccountNumber($apAccountNumber)
            ->setApAccountExternalId($apAccountExternalId);
    }
    /**
     * Get InvoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceDueDate value
     * @return string
     */
    public function getInvoiceDueDate()
    {
        return $this->InvoiceDueDate;
    }
    /**
     * Set InvoiceDueDate value
     * @param string $invoiceDueDate
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceDueDate($invoiceDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDueDate) && !is_string($invoiceDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDueDate, true), gettype($invoiceDueDate)), __LINE__);
        }
        $this->InvoiceDueDate = $invoiceDueDate;
        return $this;
    }
    /**
     * Get CanApprove value
     * @return bool
     */
    public function getCanApprove()
    {
        return $this->CanApprove;
    }
    /**
     * Set CanApprove value
     * @param bool $canApprove
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setCanApprove($canApprove = null)
    {
        // validation for constraint: boolean
        if (!is_null($canApprove) && !is_bool($canApprove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canApprove, true), gettype($canApprove)), __LINE__);
        }
        $this->CanApprove = $canApprove;
        return $this;
    }
    /**
     * Get IsPaidManually value
     * @return bool
     */
    public function getIsPaidManually()
    {
        return $this->IsPaidManually;
    }
    /**
     * Set IsPaidManually value
     * @param bool $isPaidManually
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setIsPaidManually($isPaidManually = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaidManually) && !is_bool($isPaidManually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaidManually, true), gettype($isPaidManually)), __LINE__);
        }
        $this->IsPaidManually = $isPaidManually;
        return $this;
    }
    /**
     * Get InvoiceStatus value
     * @return string
     */
    public function getInvoiceStatus()
    {
        return $this->InvoiceStatus;
    }
    /**
     * Set InvoiceStatus value
     * @uses \EnumType\TipaltiInvoiceStatus::valueIsValid()
     * @uses \EnumType\TipaltiInvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceStatus
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceStatus($invoiceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipaltiInvoiceStatus::valueIsValid($invoiceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipaltiInvoiceStatus', is_array($invoiceStatus) ? implode(', ', $invoiceStatus) : var_export($invoiceStatus, true), implode(', ', \EnumType\TipaltiInvoiceStatus::getValidValues())), __LINE__);
        }
        $this->InvoiceStatus = $invoiceStatus;
        return $this;
    }
    /**
     * Get Idap value
     * @return string|null
     */
    public function getIdap()
    {
        return $this->Idap;
    }
    /**
     * Set Idap value
     * @param string $idap
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setIdap($idap = null)
    {
        // validation for constraint: string
        if (!is_null($idap) && !is_string($idap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idap, true), gettype($idap)), __LINE__);
        }
        $this->Idap = $idap;
        return $this;
    }
    /**
     * Get InvoiceRefCode value
     * @return string|null
     */
    public function getInvoiceRefCode()
    {
        return $this->InvoiceRefCode;
    }
    /**
     * Set InvoiceRefCode value
     * @param string $invoiceRefCode
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceRefCode($invoiceRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRefCode) && !is_string($invoiceRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRefCode, true), gettype($invoiceRefCode)), __LINE__);
        }
        $this->InvoiceRefCode = $invoiceRefCode;
        return $this;
    }
    /**
     * Get InvoiceLines value
     * @return \ArrayType\ArrayOfInvoiceLine|null
     */
    public function getInvoiceLines()
    {
        return $this->InvoiceLines;
    }
    /**
     * Set InvoiceLines value
     * @param \ArrayType\ArrayOfInvoiceLine $invoiceLines
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceLines(\ArrayType\ArrayOfInvoiceLine $invoiceLines = null)
    {
        $this->InvoiceLines = $invoiceLines;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get InvoiceInternalNotes value
     * @return string|null
     */
    public function getInvoiceInternalNotes()
    {
        return $this->InvoiceInternalNotes;
    }
    /**
     * Set InvoiceInternalNotes value
     * @param string $invoiceInternalNotes
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceInternalNotes($invoiceInternalNotes = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalNotes) && !is_string($invoiceInternalNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalNotes, true), gettype($invoiceInternalNotes)), __LINE__);
        }
        $this->InvoiceInternalNotes = $invoiceInternalNotes;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setCustomFields(\ArrayType\ArrayOfKeyValuePair $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get IncomeType value
     * @return string|null
     */
    public function getIncomeType()
    {
        return $this->IncomeType;
    }
    /**
     * Set IncomeType value
     * @param string $incomeType
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setIncomeType($incomeType = null)
    {
        // validation for constraint: string
        if (!is_null($incomeType) && !is_string($incomeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomeType, true), gettype($incomeType)), __LINE__);
        }
        $this->IncomeType = $incomeType;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Approvers value
     * @return \ArrayType\ArrayOfTipaltiInvoiceApprover|null
     */
    public function getApprovers()
    {
        return $this->Approvers;
    }
    /**
     * Set Approvers value
     * @param \ArrayType\ArrayOfTipaltiInvoiceApprover $approvers
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setApprovers(\ArrayType\ArrayOfTipaltiInvoiceApprover $approvers = null)
    {
        $this->Approvers = $approvers;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get PayerEntityName value
     * @return string|null
     */
    public function getPayerEntityName()
    {
        return $this->PayerEntityName;
    }
    /**
     * Set PayerEntityName value
     * @param string $payerEntityName
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setPayerEntityName($payerEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntityName) && !is_string($payerEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntityName, true), gettype($payerEntityName)), __LINE__);
        }
        $this->PayerEntityName = $payerEntityName;
        return $this;
    }
    /**
     * Get InvoiceSubject value
     * @return string|null
     */
    public function getInvoiceSubject()
    {
        return $this->InvoiceSubject;
    }
    /**
     * Set InvoiceSubject value
     * @param string $invoiceSubject
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setInvoiceSubject($invoiceSubject = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceSubject) && !is_string($invoiceSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceSubject, true), gettype($invoiceSubject)), __LINE__);
        }
        $this->InvoiceSubject = $invoiceSubject;
        return $this;
    }
    /**
     * Get ApAccountNumber value
     * @return string|null
     */
    public function getApAccountNumber()
    {
        return $this->ApAccountNumber;
    }
    /**
     * Set ApAccountNumber value
     * @param string $apAccountNumber
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setApAccountNumber($apAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($apAccountNumber) && !is_string($apAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apAccountNumber, true), gettype($apAccountNumber)), __LINE__);
        }
        $this->ApAccountNumber = $apAccountNumber;
        return $this;
    }
    /**
     * Get ApAccountExternalId value
     * @return string|null
     */
    public function getApAccountExternalId()
    {
        return $this->ApAccountExternalId;
    }
    /**
     * Set ApAccountExternalId value
     * @param string $apAccountExternalId
     * @return \StructType\TipaltiInvoiceItemRequest
     */
    public function setApAccountExternalId($apAccountExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($apAccountExternalId) && !is_string($apAccountExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apAccountExternalId, true), gettype($apAccountExternalId)), __LINE__);
        }
        $this->ApAccountExternalId = $apAccountExternalId;
        return $this;
    }
}
