<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiInvoiceItemError StructType
 * @subpackage Structs
 */
class TipaltiInvoiceItemError extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The InvoiceRefCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRefCode;
    /**
     * Constructor method for TipaltiInvoiceItemError
     * @uses TipaltiInvoiceItemError::setErrorCode()
     * @uses TipaltiInvoiceItemError::setErrorMessage()
     * @uses TipaltiInvoiceItemError::setInvoiceRefCode()
     * @param string $errorCode
     * @param string $errorMessage
     * @param string $invoiceRefCode
     */
    public function __construct($errorCode = null, $errorMessage = null, $invoiceRefCode = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setInvoiceRefCode($invoiceRefCode);
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiInvoiceItemError
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiInvoiceItemError
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get InvoiceRefCode value
     * @return string|null
     */
    public function getInvoiceRefCode()
    {
        return $this->InvoiceRefCode;
    }
    /**
     * Set InvoiceRefCode value
     * @param string $invoiceRefCode
     * @return \StructType\TipaltiInvoiceItemError
     */
    public function setInvoiceRefCode($invoiceRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRefCode) && !is_string($invoiceRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRefCode, true), gettype($invoiceRefCode)), __LINE__);
        }
        $this->InvoiceRefCode = $invoiceRefCode;
        return $this;
    }
}
