<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiGrnItemResult StructType
 * @subpackage Structs
 */
class TipaltiGrnItemResult extends AbstractStructBase
{
    /**
     * The Succeeded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Succeeded;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptNumber;
    /**
     * Constructor method for TipaltiGrnItemResult
     * @uses TipaltiGrnItemResult::setSucceeded()
     * @uses TipaltiGrnItemResult::setErrorMessage()
     * @uses TipaltiGrnItemResult::setReceiptNumber()
     * @param bool $succeeded
     * @param string $errorMessage
     * @param string $receiptNumber
     */
    public function __construct($succeeded = null, $errorMessage = null, $receiptNumber = null)
    {
        $this
            ->setSucceeded($succeeded)
            ->setErrorMessage($errorMessage)
            ->setReceiptNumber($receiptNumber);
    }
    /**
     * Get Succeeded value
     * @return bool
     */
    public function getSucceeded()
    {
        return $this->Succeeded;
    }
    /**
     * Set Succeeded value
     * @param bool $succeeded
     * @return \StructType\TipaltiGrnItemResult
     */
    public function setSucceeded($succeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($succeeded) && !is_bool($succeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($succeeded, true), gettype($succeeded)), __LINE__);
        }
        $this->Succeeded = $succeeded;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiGrnItemResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ReceiptNumber value
     * @return string|null
     */
    public function getReceiptNumber()
    {
        return $this->ReceiptNumber;
    }
    /**
     * Set ReceiptNumber value
     * @param string $receiptNumber
     * @return \StructType\TipaltiGrnItemResult
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNumber) && !is_string($receiptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        $this->ReceiptNumber = $receiptNumber;
        return $this;
    }
}
