<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiGrnItem StructType
 * @subpackage Structs
 */
class TipaltiGrnItem extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The ReceiptDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReceiptDate;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShipmentDate;
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptNumber;
    /**
     * The PayerEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntity;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The ReceiptBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptBy;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * The GrnLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGoodsReceivedNotificationLine
     */
    public $GrnLines;
    /**
     * Constructor method for TipaltiGrnItem
     * @uses TipaltiGrnItem::setStatus()
     * @uses TipaltiGrnItem::setReceiptDate()
     * @uses TipaltiGrnItem::setShipmentDate()
     * @uses TipaltiGrnItem::setReceiptNumber()
     * @uses TipaltiGrnItem::setPayerEntity()
     * @uses TipaltiGrnItem::setSupplier()
     * @uses TipaltiGrnItem::setNotes()
     * @uses TipaltiGrnItem::setReceiptBy()
     * @uses TipaltiGrnItem::setPurchaseOrderNumber()
     * @uses TipaltiGrnItem::setGrnLines()
     * @param string $status
     * @param string $receiptDate
     * @param string $shipmentDate
     * @param string $receiptNumber
     * @param string $payerEntity
     * @param string $supplier
     * @param string $notes
     * @param string $receiptBy
     * @param string $purchaseOrderNumber
     * @param \ArrayType\ArrayOfGoodsReceivedNotificationLine $grnLines
     */
    public function __construct($status = null, $receiptDate = null, $shipmentDate = null, $receiptNumber = null, $payerEntity = null, $supplier = null, $notes = null, $receiptBy = null, $purchaseOrderNumber = null, \ArrayType\ArrayOfGoodsReceivedNotificationLine $grnLines = null)
    {
        $this
            ->setStatus($status)
            ->setReceiptDate($receiptDate)
            ->setShipmentDate($shipmentDate)
            ->setReceiptNumber($receiptNumber)
            ->setPayerEntity($payerEntity)
            ->setSupplier($supplier)
            ->setNotes($notes)
            ->setReceiptBy($receiptBy)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setGrnLines($grnLines);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EUploadCenterRecordStatus::valueIsValid()
     * @uses \EnumType\EUploadCenterRecordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TipaltiGrnItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EUploadCenterRecordStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EUploadCenterRecordStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EUploadCenterRecordStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ReceiptDate value
     * @return string
     */
    public function getReceiptDate()
    {
        return $this->ReceiptDate;
    }
    /**
     * Set ReceiptDate value
     * @param string $receiptDate
     * @return \StructType\TipaltiGrnItem
     */
    public function setReceiptDate($receiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($receiptDate) && !is_string($receiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptDate, true), gettype($receiptDate)), __LINE__);
        }
        $this->ReceiptDate = $receiptDate;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return string
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \StructType\TipaltiGrnItem
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get ReceiptNumber value
     * @return string|null
     */
    public function getReceiptNumber()
    {
        return $this->ReceiptNumber;
    }
    /**
     * Set ReceiptNumber value
     * @param string $receiptNumber
     * @return \StructType\TipaltiGrnItem
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNumber) && !is_string($receiptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        $this->ReceiptNumber = $receiptNumber;
        return $this;
    }
    /**
     * Get PayerEntity value
     * @return string|null
     */
    public function getPayerEntity()
    {
        return $this->PayerEntity;
    }
    /**
     * Set PayerEntity value
     * @param string $payerEntity
     * @return \StructType\TipaltiGrnItem
     */
    public function setPayerEntity($payerEntity = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntity) && !is_string($payerEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntity, true), gettype($payerEntity)), __LINE__);
        }
        $this->PayerEntity = $payerEntity;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \StructType\TipaltiGrnItem
     */
    public function setSupplier($supplier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier) && !is_string($supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier, true), gettype($supplier)), __LINE__);
        }
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\TipaltiGrnItem
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get ReceiptBy value
     * @return string|null
     */
    public function getReceiptBy()
    {
        return $this->ReceiptBy;
    }
    /**
     * Set ReceiptBy value
     * @param string $receiptBy
     * @return \StructType\TipaltiGrnItem
     */
    public function setReceiptBy($receiptBy = null)
    {
        // validation for constraint: string
        if (!is_null($receiptBy) && !is_string($receiptBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptBy, true), gettype($receiptBy)), __LINE__);
        }
        $this->ReceiptBy = $receiptBy;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\TipaltiGrnItem
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get GrnLines value
     * @return \ArrayType\ArrayOfGoodsReceivedNotificationLine|null
     */
    public function getGrnLines()
    {
        return $this->GrnLines;
    }
    /**
     * Set GrnLines value
     * @param \ArrayType\ArrayOfGoodsReceivedNotificationLine $grnLines
     * @return \StructType\TipaltiGrnItem
     */
    public function setGrnLines(\ArrayType\ArrayOfGoodsReceivedNotificationLine $grnLines = null)
    {
        $this->GrnLines = $grnLines;
        return $this;
    }
}
