<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiGetProcessingRequestStatusResult StructType
 * @subpackage Structs
 */
class TipaltiGetProcessingRequestStatusResult extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The requestStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $requestStatus;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for TipaltiGetProcessingRequestStatusResult
     * @uses TipaltiGetProcessingRequestStatusResult::setErrorCode()
     * @uses TipaltiGetProcessingRequestStatusResult::setRequestStatus()
     * @uses TipaltiGetProcessingRequestStatusResult::setErrorMessage()
     * @param string $errorCode
     * @param string $requestStatus
     * @param string $errorMessage
     */
    public function __construct($errorCode = null, $requestStatus = null, $errorMessage = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setRequestStatus($requestStatus)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiGetProcessingRequestStatusResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get requestStatus value
     * @return string
     */
    public function getRequestStatus()
    {
        return $this->requestStatus;
    }
    /**
     * Set requestStatus value
     * @uses \EnumType\TipaltiProcessingRequestStatus::valueIsValid()
     * @uses \EnumType\TipaltiProcessingRequestStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestStatus
     * @return \StructType\TipaltiGetProcessingRequestStatusResult
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipaltiProcessingRequestStatus::valueIsValid($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipaltiProcessingRequestStatus', is_array($requestStatus) ? implode(', ', $requestStatus) : var_export($requestStatus, true), implode(', ', \EnumType\TipaltiProcessingRequestStatus::getValidValues())), __LINE__);
        }
        $this->requestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiGetProcessingRequestStatusResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
}
