<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiGetCustomFieldsResponse StructType
 * @subpackage Structs
 */
class TipaltiGetCustomFieldsResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomFieldInfo
     */
    public $CustomFields;
    /**
     * Constructor method for TipaltiGetCustomFieldsResponse
     * @uses TipaltiGetCustomFieldsResponse::setErrorCode()
     * @uses TipaltiGetCustomFieldsResponse::setErrorMessage()
     * @uses TipaltiGetCustomFieldsResponse::setCustomFields()
     * @param string $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfCustomFieldInfo $customFields
     */
    public function __construct($errorCode = null, $errorMessage = null, \ArrayType\ArrayOfCustomFieldInfo $customFields = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setCustomFields($customFields);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiGetCustomFieldsResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiGetCustomFieldsResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfCustomFieldInfo|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfCustomFieldInfo $customFields
     * @return \StructType\TipaltiGetCustomFieldsResponse
     */
    public function setCustomFields(\ArrayType\ArrayOfCustomFieldInfo $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
}
