<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiGetBalanceResponse StructType
 * @subpackage Structs
 */
class TipaltiGetBalanceResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The AccountInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiAccountInfo
     */
    public $AccountInfos;
    /**
     * Constructor method for TipaltiGetBalanceResponse
     * @uses TipaltiGetBalanceResponse::setErrorCode()
     * @uses TipaltiGetBalanceResponse::setErrorMessage()
     * @uses TipaltiGetBalanceResponse::setAccountInfos()
     * @param int $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfTipaltiAccountInfo $accountInfos
     */
    public function __construct($errorCode = null, $errorMessage = null, \ArrayType\ArrayOfTipaltiAccountInfo $accountInfos = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setAccountInfos($accountInfos);
    }
    /**
     * Get errorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\TipaltiGetBalanceResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiGetBalanceResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get AccountInfos value
     * @return \ArrayType\ArrayOfTipaltiAccountInfo|null
     */
    public function getAccountInfos()
    {
        return $this->AccountInfos;
    }
    /**
     * Set AccountInfos value
     * @param \ArrayType\ArrayOfTipaltiAccountInfo $accountInfos
     * @return \StructType\TipaltiGetBalanceResponse
     */
    public function setAccountInfos(\ArrayType\ArrayOfTipaltiAccountInfo $accountInfos = null)
    {
        $this->AccountInfos = $accountInfos;
        return $this;
    }
}
