<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiCustomFieldValueUpdateResponse StructType
 * @subpackage Structs
 */
class TipaltiCustomFieldValueUpdateResponse extends TipaltiResponse
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Result;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The CustomFieldValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TipaltiCustomFieldValue
     */
    public $CustomFieldValue;
    /**
     * Constructor method for TipaltiCustomFieldValueUpdateResponse
     * @uses TipaltiCustomFieldValueUpdateResponse::setResult()
     * @uses TipaltiCustomFieldValueUpdateResponse::setMessage()
     * @uses TipaltiCustomFieldValueUpdateResponse::setCustomFieldValue()
     * @param string $result
     * @param string $message
     * @param \StructType\TipaltiCustomFieldValue $customFieldValue
     */
    public function __construct($result = null, $message = null, \StructType\TipaltiCustomFieldValue $customFieldValue = null)
    {
        $this
            ->setResult($result)
            ->setMessage($message)
            ->setCustomFieldValue($customFieldValue);
    }
    /**
     * Get Result value
     * @return string
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @uses \EnumType\CustomFieldUpdateResult::valueIsValid()
     * @uses \EnumType\CustomFieldUpdateResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \StructType\TipaltiCustomFieldValueUpdateResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomFieldUpdateResult::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomFieldUpdateResult', is_array($result) ? implode(', ', $result) : var_export($result, true), implode(', ', \EnumType\CustomFieldUpdateResult::getValidValues())), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\TipaltiCustomFieldValueUpdateResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CustomFieldValue value
     * @return \StructType\TipaltiCustomFieldValue|null
     */
    public function getCustomFieldValue()
    {
        return $this->CustomFieldValue;
    }
    /**
     * Set CustomFieldValue value
     * @param \StructType\TipaltiCustomFieldValue $customFieldValue
     * @return \StructType\TipaltiCustomFieldValueUpdateResponse
     */
    public function setCustomFieldValue(\StructType\TipaltiCustomFieldValue $customFieldValue = null)
    {
        $this->CustomFieldValue = $customFieldValue;
        return $this;
    }
}
