<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiCustomFieldUpdateResponse StructType
 * @subpackage Structs
 */
class TipaltiCustomFieldUpdateResponse extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Result;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The CustomField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TipaltiCustomField
     */
    public $CustomField;
    /**
     * Constructor method for TipaltiCustomFieldUpdateResponse
     * @uses TipaltiCustomFieldUpdateResponse::setResult()
     * @uses TipaltiCustomFieldUpdateResponse::setMessage()
     * @uses TipaltiCustomFieldUpdateResponse::setCustomField()
     * @param string $result
     * @param string $message
     * @param \StructType\TipaltiCustomField $customField
     */
    public function __construct($result = null, $message = null, \StructType\TipaltiCustomField $customField = null)
    {
        $this
            ->setResult($result)
            ->setMessage($message)
            ->setCustomField($customField);
    }
    /**
     * Get Result value
     * @return string
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @uses \EnumType\CustomFieldUpdateResult::valueIsValid()
     * @uses \EnumType\CustomFieldUpdateResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \StructType\TipaltiCustomFieldUpdateResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomFieldUpdateResult::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomFieldUpdateResult', is_array($result) ? implode(', ', $result) : var_export($result, true), implode(', ', \EnumType\CustomFieldUpdateResult::getValidValues())), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\TipaltiCustomFieldUpdateResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CustomField value
     * @return \StructType\TipaltiCustomField|null
     */
    public function getCustomField()
    {
        return $this->CustomField;
    }
    /**
     * Set CustomField value
     * @param \StructType\TipaltiCustomField $customField
     * @return \StructType\TipaltiCustomFieldUpdateResponse
     */
    public function setCustomField(\StructType\TipaltiCustomField $customField = null)
    {
        $this->CustomField = $customField;
        return $this;
    }
}
