<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiCustomField StructType
 * @subpackage Structs
 */
class TipaltiCustomField extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The Entity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Entity;
    /**
     * The SubEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SubEntity;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The IframeDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IframeDisplay;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomFieldValue
     */
    public $Values;
    /**
     * Constructor method for TipaltiCustomField
     * @uses TipaltiCustomField::setAction()
     * @uses TipaltiCustomField::setEntity()
     * @uses TipaltiCustomField::setSubEntity()
     * @uses TipaltiCustomField::setType()
     * @uses TipaltiCustomField::setIframeDisplay()
     * @uses TipaltiCustomField::setTitle()
     * @uses TipaltiCustomField::setDescription()
     * @uses TipaltiCustomField::setValues()
     * @param string $action
     * @param string $entity
     * @param string $subEntity
     * @param string $type
     * @param bool $iframeDisplay
     * @param string $title
     * @param string $description
     * @param \ArrayType\ArrayOfCustomFieldValue $values
     */
    public function __construct($action = null, $entity = null, $subEntity = null, $type = null, $iframeDisplay = null, $title = null, $description = null, \ArrayType\ArrayOfCustomFieldValue $values = null)
    {
        $this
            ->setAction($action)
            ->setEntity($entity)
            ->setSubEntity($subEntity)
            ->setType($type)
            ->setIframeDisplay($iframeDisplay)
            ->setTitle($title)
            ->setDescription($description)
            ->setValues($values);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\CustomFieldAction::valueIsValid()
     * @uses \EnumType\CustomFieldAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\TipaltiCustomField
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomFieldAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomFieldAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\CustomFieldAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Entity value
     * @return string
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @uses \EnumType\CustomFieldEntity::valueIsValid()
     * @uses \EnumType\CustomFieldEntity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entity
     * @return \StructType\TipaltiCustomField
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomFieldEntity::valueIsValid($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomFieldEntity', is_array($entity) ? implode(', ', $entity) : var_export($entity, true), implode(', ', \EnumType\CustomFieldEntity::getValidValues())), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get SubEntity value
     * @return string
     */
    public function getSubEntity()
    {
        return $this->SubEntity;
    }
    /**
     * Set SubEntity value
     * @uses \EnumType\CustomFieldSubEntity::valueIsValid()
     * @uses \EnumType\CustomFieldSubEntity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subEntity
     * @return \StructType\TipaltiCustomField
     */
    public function setSubEntity($subEntity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomFieldSubEntity::valueIsValid($subEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomFieldSubEntity', is_array($subEntity) ? implode(', ', $subEntity) : var_export($subEntity, true), implode(', ', \EnumType\CustomFieldSubEntity::getValidValues())), __LINE__);
        }
        $this->SubEntity = $subEntity;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\CustomFieldType::valueIsValid()
     * @uses \EnumType\CustomFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\TipaltiCustomField
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomFieldType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomFieldType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\CustomFieldType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IframeDisplay value
     * @return bool
     */
    public function getIframeDisplay()
    {
        return $this->IframeDisplay;
    }
    /**
     * Set IframeDisplay value
     * @param bool $iframeDisplay
     * @return \StructType\TipaltiCustomField
     */
    public function setIframeDisplay($iframeDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($iframeDisplay) && !is_bool($iframeDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iframeDisplay, true), gettype($iframeDisplay)), __LINE__);
        }
        $this->IframeDisplay = $iframeDisplay;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\TipaltiCustomField
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TipaltiCustomField
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Values value
     * @return \ArrayType\ArrayOfCustomFieldValue|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \ArrayType\ArrayOfCustomFieldValue $values
     * @return \StructType\TipaltiCustomField
     */
    public function setValues(\ArrayType\ArrayOfCustomFieldValue $values = null)
    {
        $this->Values = $values;
        return $this;
    }
}
