<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TestMultiCurrencyPaymentFile StructType
 * @subpackage Structs
 */
class TestMultiCurrencyPaymentFile extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileName;
    /**
     * Constructor method for TestMultiCurrencyPaymentFile
     * @uses TestMultiCurrencyPaymentFile::setTimestamp()
     * @uses TestMultiCurrencyPaymentFile::setPayerName()
     * @uses TestMultiCurrencyPaymentFile::setKey()
     * @uses TestMultiCurrencyPaymentFile::setFileName()
     * @param float $timestamp
     * @param string $payerName
     * @param string $key
     * @param string $fileName
     */
    public function __construct($timestamp = null, $payerName = null, $key = null, $fileName = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setFileName($fileName);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\TestMultiCurrencyPaymentFile
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\TestMultiCurrencyPaymentFile
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\TestMultiCurrencyPaymentFile
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\TestMultiCurrencyPaymentFile
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
}
