<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrderLine StructType
 * @subpackage Structs
 */
class PurchaseOrderLine extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Rate;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The DiscountValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountValue;
    /**
     * The NetValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $NetValue;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxAmount;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LineType;
    /**
     * The BilledQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BilledQuantity;
    /**
     * The BilledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BilledAmount;
    /**
     * The IsClosed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsClosed;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item;
    /**
     * The Units
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Units;
    /**
     * The LineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineDescription;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $CustomFields;
    /**
     * The PoLineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoLineId;
    /**
     * The AccountExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountExternalId;
    /**
     * The ItemExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemExternalId;
    /**
     * The TaxCodeExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCodeExternalId;
    /**
     * Constructor method for PurchaseOrderLine
     * @uses PurchaseOrderLine::setQuantity()
     * @uses PurchaseOrderLine::setRate()
     * @uses PurchaseOrderLine::setAmount()
     * @uses PurchaseOrderLine::setDiscountValue()
     * @uses PurchaseOrderLine::setNetValue()
     * @uses PurchaseOrderLine::setTaxAmount()
     * @uses PurchaseOrderLine::setLineType()
     * @uses PurchaseOrderLine::setBilledQuantity()
     * @uses PurchaseOrderLine::setBilledAmount()
     * @uses PurchaseOrderLine::setIsClosed()
     * @uses PurchaseOrderLine::setItem()
     * @uses PurchaseOrderLine::setUnits()
     * @uses PurchaseOrderLine::setLineDescription()
     * @uses PurchaseOrderLine::setAccount()
     * @uses PurchaseOrderLine::setCustomFields()
     * @uses PurchaseOrderLine::setPoLineId()
     * @uses PurchaseOrderLine::setAccountExternalId()
     * @uses PurchaseOrderLine::setItemExternalId()
     * @uses PurchaseOrderLine::setTaxCodeExternalId()
     * @param float $quantity
     * @param float $rate
     * @param float $amount
     * @param float $discountValue
     * @param float $netValue
     * @param float $taxAmount
     * @param string $lineType
     * @param float $billedQuantity
     * @param float $billedAmount
     * @param bool $isClosed
     * @param string $item
     * @param string $units
     * @param string $lineDescription
     * @param string $account
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @param string $poLineId
     * @param string $accountExternalId
     * @param string $itemExternalId
     * @param string $taxCodeExternalId
     */
    public function __construct($quantity = null, $rate = null, $amount = null, $discountValue = null, $netValue = null, $taxAmount = null, $lineType = null, $billedQuantity = null, $billedAmount = null, $isClosed = null, $item = null, $units = null, $lineDescription = null, $account = null, \ArrayType\ArrayOfKeyValuePair $customFields = null, $poLineId = null, $accountExternalId = null, $itemExternalId = null, $taxCodeExternalId = null)
    {
        $this
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setAmount($amount)
            ->setDiscountValue($discountValue)
            ->setNetValue($netValue)
            ->setTaxAmount($taxAmount)
            ->setLineType($lineType)
            ->setBilledQuantity($billedQuantity)
            ->setBilledAmount($billedAmount)
            ->setIsClosed($isClosed)
            ->setItem($item)
            ->setUnits($units)
            ->setLineDescription($lineDescription)
            ->setAccount($account)
            ->setCustomFields($customFields)
            ->setPoLineId($poLineId)
            ->setAccountExternalId($accountExternalId)
            ->setItemExternalId($itemExternalId)
            ->setTaxCodeExternalId($taxCodeExternalId);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\PurchaseOrderLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\PurchaseOrderLine
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PurchaseOrderLine
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get DiscountValue value
     * @return float
     */
    public function getDiscountValue()
    {
        return $this->DiscountValue;
    }
    /**
     * Set DiscountValue value
     * @param float $discountValue
     * @return \StructType\PurchaseOrderLine
     */
    public function setDiscountValue($discountValue = null)
    {
        // validation for constraint: float
        if (!is_null($discountValue) && !(is_float($discountValue) || is_numeric($discountValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountValue, true), gettype($discountValue)), __LINE__);
        }
        $this->DiscountValue = $discountValue;
        return $this;
    }
    /**
     * Get NetValue value
     * @return float
     */
    public function getNetValue()
    {
        return $this->NetValue;
    }
    /**
     * Set NetValue value
     * @param float $netValue
     * @return \StructType\PurchaseOrderLine
     */
    public function setNetValue($netValue = null)
    {
        // validation for constraint: float
        if (!is_null($netValue) && !(is_float($netValue) || is_numeric($netValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netValue, true), gettype($netValue)), __LINE__);
        }
        $this->NetValue = $netValue;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\PurchaseOrderLine
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get LineType value
     * @return string
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @uses \EnumType\ELineType::valueIsValid()
     * @uses \EnumType\ELineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineType
     * @return \StructType\PurchaseOrderLine
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ELineType::valueIsValid($lineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ELineType', is_array($lineType) ? implode(', ', $lineType) : var_export($lineType, true), implode(', ', \EnumType\ELineType::getValidValues())), __LINE__);
        }
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get BilledQuantity value
     * @return float
     */
    public function getBilledQuantity()
    {
        return $this->BilledQuantity;
    }
    /**
     * Set BilledQuantity value
     * @param float $billedQuantity
     * @return \StructType\PurchaseOrderLine
     */
    public function setBilledQuantity($billedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($billedQuantity) && !(is_float($billedQuantity) || is_numeric($billedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($billedQuantity, true), gettype($billedQuantity)), __LINE__);
        }
        $this->BilledQuantity = $billedQuantity;
        return $this;
    }
    /**
     * Get BilledAmount value
     * @return float
     */
    public function getBilledAmount()
    {
        return $this->BilledAmount;
    }
    /**
     * Set BilledAmount value
     * @param float $billedAmount
     * @return \StructType\PurchaseOrderLine
     */
    public function setBilledAmount($billedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($billedAmount) && !(is_float($billedAmount) || is_numeric($billedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($billedAmount, true), gettype($billedAmount)), __LINE__);
        }
        $this->BilledAmount = $billedAmount;
        return $this;
    }
    /**
     * Get IsClosed value
     * @return bool
     */
    public function getIsClosed()
    {
        return $this->IsClosed;
    }
    /**
     * Set IsClosed value
     * @param bool $isClosed
     * @return \StructType\PurchaseOrderLine
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->IsClosed = $isClosed;
        return $this;
    }
    /**
     * Get Item value
     * @return string|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param string $item
     * @return \StructType\PurchaseOrderLine
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param string $units
     * @return \StructType\PurchaseOrderLine
     */
    public function setUnits($units = null)
    {
        // validation for constraint: string
        if (!is_null($units) && !is_string($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get LineDescription value
     * @return string|null
     */
    public function getLineDescription()
    {
        return $this->LineDescription;
    }
    /**
     * Set LineDescription value
     * @param string $lineDescription
     * @return \StructType\PurchaseOrderLine
     */
    public function setLineDescription($lineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lineDescription) && !is_string($lineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineDescription, true), gettype($lineDescription)), __LINE__);
        }
        $this->LineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\PurchaseOrderLine
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfKeyValuePair $customFields
     * @return \StructType\PurchaseOrderLine
     */
    public function setCustomFields(\ArrayType\ArrayOfKeyValuePair $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get PoLineId value
     * @return string|null
     */
    public function getPoLineId()
    {
        return $this->PoLineId;
    }
    /**
     * Set PoLineId value
     * @param string $poLineId
     * @return \StructType\PurchaseOrderLine
     */
    public function setPoLineId($poLineId = null)
    {
        // validation for constraint: string
        if (!is_null($poLineId) && !is_string($poLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poLineId, true), gettype($poLineId)), __LINE__);
        }
        $this->PoLineId = $poLineId;
        return $this;
    }
    /**
     * Get AccountExternalId value
     * @return string|null
     */
    public function getAccountExternalId()
    {
        return $this->AccountExternalId;
    }
    /**
     * Set AccountExternalId value
     * @param string $accountExternalId
     * @return \StructType\PurchaseOrderLine
     */
    public function setAccountExternalId($accountExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($accountExternalId) && !is_string($accountExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountExternalId, true), gettype($accountExternalId)), __LINE__);
        }
        $this->AccountExternalId = $accountExternalId;
        return $this;
    }
    /**
     * Get ItemExternalId value
     * @return string|null
     */
    public function getItemExternalId()
    {
        return $this->ItemExternalId;
    }
    /**
     * Set ItemExternalId value
     * @param string $itemExternalId
     * @return \StructType\PurchaseOrderLine
     */
    public function setItemExternalId($itemExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($itemExternalId) && !is_string($itemExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemExternalId, true), gettype($itemExternalId)), __LINE__);
        }
        $this->ItemExternalId = $itemExternalId;
        return $this;
    }
    /**
     * Get TaxCodeExternalId value
     * @return string|null
     */
    public function getTaxCodeExternalId()
    {
        return $this->TaxCodeExternalId;
    }
    /**
     * Set TaxCodeExternalId value
     * @param string $taxCodeExternalId
     * @return \StructType\PurchaseOrderLine
     */
    public function setTaxCodeExternalId($taxCodeExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($taxCodeExternalId) && !is_string($taxCodeExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCodeExternalId, true), gettype($taxCodeExternalId)), __LINE__);
        }
        $this->TaxCodeExternalId = $taxCodeExternalId;
        return $this;
    }
}
