<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineErrorOrWarning StructType
 * @subpackage Structs
 */
class LineErrorOrWarning extends AbstractStructBase
{
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $lineNumber;
    /**
     * The isWarning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isWarning;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for LineErrorOrWarning
     * @uses LineErrorOrWarning::setLineNumber()
     * @uses LineErrorOrWarning::setIsWarning()
     * @uses LineErrorOrWarning::setMessage()
     * @param int $lineNumber
     * @param bool $isWarning
     * @param string $message
     */
    public function __construct($lineNumber = null, $isWarning = null, $message = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setIsWarning($isWarning)
            ->setMessage($message);
    }
    /**
     * Get lineNumber value
     * @return int
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param int $lineNumber
     * @return \StructType\LineErrorOrWarning
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get isWarning value
     * @return bool
     */
    public function getIsWarning()
    {
        return $this->isWarning;
    }
    /**
     * Set isWarning value
     * @param bool $isWarning
     * @return \StructType\LineErrorOrWarning
     */
    public function setIsWarning($isWarning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWarning) && !is_bool($isWarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWarning, true), gettype($isWarning)), __LINE__);
        }
        $this->isWarning = $isWarning;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\LineErrorOrWarning
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
