<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationErrorItem StructType
 * @subpackage Structs
 */
class IntegrationErrorItem extends AbstractStructBase
{
    /**
     * The CreationTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreationTimestamp;
    /**
     * The SyncDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SyncDirection;
    /**
     * The ErrorSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorSubject;
    /**
     * The ErrorDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorDetails;
    /**
     * The IntegrationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationName;
    /**
     * The IntegrationVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationVersion;
    /**
     * Constructor method for IntegrationErrorItem
     * @uses IntegrationErrorItem::setCreationTimestamp()
     * @uses IntegrationErrorItem::setSyncDirection()
     * @uses IntegrationErrorItem::setErrorSubject()
     * @uses IntegrationErrorItem::setErrorDetails()
     * @uses IntegrationErrorItem::setIntegrationName()
     * @uses IntegrationErrorItem::setIntegrationVersion()
     * @param int $creationTimestamp
     * @param string $syncDirection
     * @param string $errorSubject
     * @param string $errorDetails
     * @param string $integrationName
     * @param string $integrationVersion
     */
    public function __construct($creationTimestamp = null, $syncDirection = null, $errorSubject = null, $errorDetails = null, $integrationName = null, $integrationVersion = null)
    {
        $this
            ->setCreationTimestamp($creationTimestamp)
            ->setSyncDirection($syncDirection)
            ->setErrorSubject($errorSubject)
            ->setErrorDetails($errorDetails)
            ->setIntegrationName($integrationName)
            ->setIntegrationVersion($integrationVersion);
    }
    /**
     * Get CreationTimestamp value
     * @return int
     */
    public function getCreationTimestamp()
    {
        return $this->CreationTimestamp;
    }
    /**
     * Set CreationTimestamp value
     * @param int $creationTimestamp
     * @return \StructType\IntegrationErrorItem
     */
    public function setCreationTimestamp($creationTimestamp = null)
    {
        // validation for constraint: int
        if (!is_null($creationTimestamp) && !(is_int($creationTimestamp) || ctype_digit($creationTimestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationTimestamp, true), gettype($creationTimestamp)), __LINE__);
        }
        $this->CreationTimestamp = $creationTimestamp;
        return $this;
    }
    /**
     * Get SyncDirection value
     * @return string|null
     */
    public function getSyncDirection()
    {
        return $this->SyncDirection;
    }
    /**
     * Set SyncDirection value
     * @param string $syncDirection
     * @return \StructType\IntegrationErrorItem
     */
    public function setSyncDirection($syncDirection = null)
    {
        // validation for constraint: string
        if (!is_null($syncDirection) && !is_string($syncDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncDirection, true), gettype($syncDirection)), __LINE__);
        }
        $this->SyncDirection = $syncDirection;
        return $this;
    }
    /**
     * Get ErrorSubject value
     * @return string|null
     */
    public function getErrorSubject()
    {
        return $this->ErrorSubject;
    }
    /**
     * Set ErrorSubject value
     * @param string $errorSubject
     * @return \StructType\IntegrationErrorItem
     */
    public function setErrorSubject($errorSubject = null)
    {
        // validation for constraint: string
        if (!is_null($errorSubject) && !is_string($errorSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorSubject, true), gettype($errorSubject)), __LINE__);
        }
        $this->ErrorSubject = $errorSubject;
        return $this;
    }
    /**
     * Get ErrorDetails value
     * @return string|null
     */
    public function getErrorDetails()
    {
        return $this->ErrorDetails;
    }
    /**
     * Set ErrorDetails value
     * @param string $errorDetails
     * @return \StructType\IntegrationErrorItem
     */
    public function setErrorDetails($errorDetails = null)
    {
        // validation for constraint: string
        if (!is_null($errorDetails) && !is_string($errorDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDetails, true), gettype($errorDetails)), __LINE__);
        }
        $this->ErrorDetails = $errorDetails;
        return $this;
    }
    /**
     * Get IntegrationName value
     * @return string|null
     */
    public function getIntegrationName()
    {
        return $this->IntegrationName;
    }
    /**
     * Set IntegrationName value
     * @param string $integrationName
     * @return \StructType\IntegrationErrorItem
     */
    public function setIntegrationName($integrationName = null)
    {
        // validation for constraint: string
        if (!is_null($integrationName) && !is_string($integrationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationName, true), gettype($integrationName)), __LINE__);
        }
        $this->IntegrationName = $integrationName;
        return $this;
    }
    /**
     * Get IntegrationVersion value
     * @return string|null
     */
    public function getIntegrationVersion()
    {
        return $this->IntegrationVersion;
    }
    /**
     * Set IntegrationVersion value
     * @param string $integrationVersion
     * @return \StructType\IntegrationErrorItem
     */
    public function setIntegrationVersion($integrationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($integrationVersion) && !is_string($integrationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationVersion, true), gettype($integrationVersion)), __LINE__);
        }
        $this->IntegrationVersion = $integrationVersion;
        return $this;
    }
}
