<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUpdatedPayments StructType
 * @subpackage Structs
 */
class GetUpdatedPayments extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The changedSince
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $changedSince;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * Constructor method for GetUpdatedPayments
     * @uses GetUpdatedPayments::setTimestamp()
     * @uses GetUpdatedPayments::setChangedSince()
     * @uses GetUpdatedPayments::setPayerName()
     * @uses GetUpdatedPayments::setKey()
     * @param float $timestamp
     * @param float $changedSince
     * @param string $payerName
     * @param string $key
     */
    public function __construct($timestamp = null, $changedSince = null, $payerName = null, $key = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setChangedSince($changedSince)
            ->setPayerName($payerName)
            ->setKey($key);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\GetUpdatedPayments
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get changedSince value
     * @return float
     */
    public function getChangedSince()
    {
        return $this->changedSince;
    }
    /**
     * Set changedSince value
     * @param float $changedSince
     * @return \StructType\GetUpdatedPayments
     */
    public function setChangedSince($changedSince = null)
    {
        // validation for constraint: float
        if (!is_null($changedSince) && !(is_float($changedSince) || is_numeric($changedSince))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($changedSince, true), gettype($changedSince)), __LINE__);
        }
        $this->changedSince = $changedSince;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\GetUpdatedPayments
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetUpdatedPayments
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
